package cn.com.duiba.tuia.ssp.center.api.constant;

/**
 * 
 * ClassName: DataSourceType <br/>
 * Function: 来源类型 <br/>
 * date: 2017年11月29日 下午7:03:39 <br/>
 *
 * @author guyan
 * @version 
 * @since JDK 1.6
 */
public enum DataSourceType {
   
    DATA_SLOT_DIRECT_ACT_TYPE(0, "广告位直投活动"),
    
    DATA_SLOT_DIRECT_PAGE_TYPE(1, "广告位直投直投页"),
    
    DATA_SLOT_DIRECT_MAIN_TYPE(2, "广告位直投主会场"),
    
    DATA_SLOT_DIRECT_CENTER_TYPE(3, "广告位直投活动中心"),
    
    DATA_SLOT_DIRECT_BOUY_TYPE(4, "浮标"),
    
    DATA_SLOT_DIRECT_BACK_TYPE(5, "返回拦截"),
    
    DATA_SLOT_DIRECT_LAYERS_TYPE(6, "推荐弹层"),
    
    DATA_SLOT_DIRECT_OLD_TYPE(7, "未区分来源数据");
    
    
    
    private Integer type;

    private String  desc;


    DataSourceType(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }
    
    public static String getDescByType(Integer type) {
        String desc = "";
        for (DataSourceType temp : DataSourceType.values()) {
            if (temp.getType().equals(type)) {
                desc = temp.getDesc();
            }
        }
        return desc;
    }

}
