package cn.com.duiba.tuia.ssp.center.api.constant.risk;

/**
 * 〈一句话功能简述〉<br>
 * Description: 审核状态
 *
 * @author hillchen
 * @create 2018/9/20 下午2:50
 */
public enum AuditState {
    /**
     * 初始化未提交数据，暂时未使用
     */
    DATA_INIT(0,"数据初始化"),
    /**
     * 待审核
     */
    AUDIT_TODO(1,"待审核"),
    /**
     * 审核通过
     */
    AUDIT_SUCC(2,"审核通过"),
    /**
     * 审核拒绝
     */
    AUDIT_FAIL(3,"审核拒绝");
    private int state;

    private String name;

    AuditState(int state, String name) {
        this.state = state;
        this.name = name;
    }

    public int getState() {
        return state;
    }

    public String getName() {
        return name;
    }

    public  boolean checkIsSameState(Integer state){
        return state != null && this.state == state;
    }
}
