package cn.com.duiba.tuia.ssp.center.api.dto.wechat;

import cn.com.duiba.tuia.ssp.center.api.dto.BaseQueryDto;
import org.apache.commons.lang3.builder.ToStringBuilder;

import java.io.Serializable;
import java.util.Date;

/**
 * 微信自动推送消息请求参数
 *
 * @author zhangzhenghe
 * @since 2019-12-05 15:59
 */
public class ReqWeChatAutoNotice extends BaseQueryDto implements Serializable {

    private static final long serialVersionUID = 3489332915944407196L;

    /**
     * 媒体用户ID
     */
    private Long mediaId;

    /**
     * 媒体账号
     */
    private String email;

    /**
     * 通知开始日期
     */
    private String noticeStartDate;

    /**
     * 通知截止日期
     */
    private String noticeEndDate;

    /**
     * 通知类型 -1：全部 0：结算生成 1：提现审核
     */
    private Integer noticeType;

    /**
     * 通知具体类型 0-结算单已生成合同尚未签署 1-结算单已生成且提现金额满足条件（>100）
     * 2-结算单已生成但提现金额不满足条件 3-申请提现提交成功 4-请款通过 5-财务审核通过
     * 6-已打款 7-提现审核拒绝
     */
    private Integer noticeDetailType;

    /**
     * 公司名称
     */
    private String companyName;

    /**
     * 微信绑定用户id
     */
    private String openId;

    /**
     * 微信名称
     */
    private String nick;

    /**
     * 单号
     */
    private String orderNum;

    /**
     * 通知内容
     */
    private String content;

    /**
     * 通知时间
     */
    private Date noticeTime;

    /**
     * 账单日期
     */
    private String orderTime;

    /**
     * 应用id
     */
    private Long appId;

    public Long getMediaId() {
        return mediaId;
    }

    public void setMediaId(Long mediaId) {
        this.mediaId = mediaId;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getNoticeStartDate() {
        return noticeStartDate;
    }

    public void setNoticeStartDate(String noticeStartDate) {
        this.noticeStartDate = noticeStartDate;
    }

    public String getNoticeEndDate() {
        return noticeEndDate;
    }

    public void setNoticeEndDate(String noticeEndDate) {
        this.noticeEndDate = noticeEndDate;
    }

    public Integer getNoticeType() {
        return noticeType;
    }

    public void setNoticeType(Integer noticeType) {
        this.noticeType = noticeType;
    }

    public Integer getNoticeDetailType() {
        return noticeDetailType;
    }

    public void setNoticeDetailType(Integer noticeDetailType) {
        this.noticeDetailType = noticeDetailType;
    }

    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public String getOpenId() {
        return openId;
    }

    public void setOpenId(String openId) {
        this.openId = openId;
    }

    public String getNick() {
        return nick;
    }

    public void setNick(String nick) {
        this.nick = nick;
    }

    public String getOrderNum() {
        return orderNum;
    }

    public void setOrderNum(String orderNum) {
        this.orderNum = orderNum;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public Date getNoticeTime() {
        return noticeTime;
    }

    public void setNoticeTime(Date noticeTime) {
        this.noticeTime = noticeTime;
    }

    public String getOrderTime() {
        return orderTime;
    }

    public void setOrderTime(String orderTime) {
        this.orderTime = orderTime;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}
