package cn.com.duiba.tuia.ssp.center.api.query;

import cn.com.duiba.tuia.ssp.center.api.dto.BaseQueryDto;
import lombok.Data;
import lombok.ToString;

import java.util.Date;

/**
 * 媒体投放配置查询实体类
 * @author K. L. Mao
 * @create 2019-12-09
 */
@Data
@ToString(callSuper = true)
public class MediaPutConfigQuery extends BaseQueryDto {

    private Long id;

    /**
     * 应用ID
     */
    private Long appId;

    /**
     * 是否收集用户信息
     */
    private Boolean isCollectUserInfo;

    /**
     * 是否支持下载器能力
     */
    private Boolean isSupportDownload;

    /**
     * 是否支持关闭
     */
    private Boolean isSupportClose;

    /**
     * 是否支持文件缓冲采集
     */
    private Boolean isSupportFileCache;

    /**
     * 创建起始时间
     */
    private Date gmtCreateFrom;

    /**
     * 创建结束时间
     */
    private Date gmtCreateTo;

    /**
     * 修改起始时间
     */
    private Date gmtModifiedFrom;

    /**
     * 修改结束时间
     */
    private Date gmtModifiedTo;
}
