package cn.com.duiba.tuia.ssp.center.api.remote.interflow.remoteservice.media;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.PageResultDto;
import cn.com.duiba.tuia.ssp.center.api.remote.interflow.dto.FlowApplyDeatilDto;
import cn.com.duiba.tuia.ssp.center.api.remote.interflow.dto.FlowApplyRecodeDto;
import cn.com.duiba.tuia.ssp.center.api.remote.interflow.dto.TuiaAppDiDto;
import cn.com.duiba.tuia.ssp.center.api.remote.interflow.dto.media.req.FlowApplyCopmReq;
import cn.com.duiba.tuia.ssp.center.api.remote.interflow.dto.media.req.FlowApplyDetailReq;
import cn.com.duiba.tuia.ssp.center.api.remote.interflow.dto.media.req.FlowApplyRecodeReq;
import cn.com.duiba.tuia.ssp.center.api.remote.interflow.dto.media.req.FlowApplyReq;
import cn.com.duiba.tuia.ssp.center.api.remote.interflow.dto.media.rsp.FlowApplyCompRsp;

import java.util.List;

/**
 * 〈一句话功能简述〉<br>
 * Description: 媒体流量申请远程服务接口
 *
 * @author hillchen
 * @create 2018/11/8 21:19
 */
@AdvancedFeignClient
public interface RemoteFlowApplyService {
    /**
     * 查询申请资格列表
     * @param flowApplyCopmReq
     * @return
     */
    PageResultDto<FlowApplyCompRsp> findFlowApplyComp(FlowApplyCopmReq flowApplyCopmReq);

    /**
     * 查询申请记录列表
     * @param flowApplyRecodeReq
     * @return
     */
    PageResultDto<FlowApplyRecodeDto> findFlowApplyRecodes(FlowApplyRecodeReq flowApplyRecodeReq);

    /**
     * 查询申请记录列表
     * @param flowApplyDetailReq
     * @return
     */
    List<FlowApplyDeatilDto> findFlowApplyDetails(FlowApplyDetailReq flowApplyDetailReq);

    /**
     * 媒体填充流量
     *
     * @param flowApplyReq
     * @return
     */
    FlowApplyRecodeDto insertAppApplyFlows(FlowApplyReq flowApplyReq);


    /**
     * 查询app 当日统计数据
     *
     * @param appIds
     * @return
     */
    List<TuiaAppDiDto> listAppTodayCountData(List<Long> appIds);

    /**
     * 查询申请记录列表
     *
     * @param applyId
     * @return
     */
    List<FlowApplyDeatilDto> listFlowApplyDetail(Long applyId);

    /**
     * 申请请求入队
     *
     * @param applyId
     * @return
     */
    Boolean pushQueueByApplyId(Long applyId);

}