package cn.com.duiba.tuia.ssp.center.api.remote.media.dto.meituan.request;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import java.io.Serializable;

/**
 * 创意 ( 广告 ) Request
 * @dateTime 2019-10-09 11:51:27
 * @author haitao.hua
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Accessors(fluent = false, chain = true, prefix = "")
public class ListingRequest implements Serializable {

    /*
     * 广告 Id
     * 是否必填 : 否
     */
    private Long advertId;

    /*
     * 审核状态
     * 注: { 0 : 初始化 , 1 : 待审核 , 2 : 审核通过 , 3 : 审核拒接 , 4 : 系统下线 }
     * 是否必填 : 否
     */
    private Integer status;

    /*
     * 投放开关
     * 注: { 0 : 关闭 , 1 : 开启 }
     */
    private Integer materialSwitch;

    /*
     * 分页页数
     * 是否必填 : 是
     */
    private Integer currentPage;

    /*
     * 分页条数
     * 是否必填 : 是
     */
    private Integer pageSize;

}
