package cn.com.duiba.tuia.ssp.center.api.remote.media.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;

/**
 * 开关枚举
 * 注: 素材投放开关.
 * @dateTime 2019-11-06 17:51:27
 * @author haitao.hua
 */
@NoArgsConstructor
@AllArgsConstructor
@Accessors(fluent = true, chain = true, prefix = "")
public enum MaterialSwitchEnum {

    /*################################# 素材投放开关的枚举 ( Start ) #####################################*/

    Close(0, "关闭"),
    Open(1, "开启");

    /*################################# 素材投放开关的枚举 ( end ) #######################################*/

    /**
     * 标识码
     */
    @Getter
    private Integer code;

    /**
     * 备注
     */
    @Getter
    private String remark;

    /**
     * Seek 值
     * @param code 标识码
     * @return 结果
     */
    public static MaterialSwitchEnum seekValue(Integer code) {
        Optional<MaterialSwitchEnum> result = Arrays.stream(MaterialSwitchEnum.values()).filter(target -> (Objects.nonNull(target) && target.code.equals(code))).findFirst();
        return result.orElse(null);
    }

}
