/**
 * Project Name:media-api File Name:ReqDataStatisticsByPageDto.java Package Name:cn.com.duiba.tuia.media.api.dto.req
 * Date:2016年10月11日下午3:09:44 Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.ssp.center.api.dto.abnormal;

import cn.com.duiba.tuia.ssp.center.api.dto.BaseQueryDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.springframework.format.annotation.DateTimeFormat;

import javax.validation.constraints.NotNull;
import java.util.Date;
import java.util.List;

/**
 * @Author zhangliwei
 * @Description  异常数据分页请求参数
 * @Date 17:15 2020-03-06
 * @Param
 * @return
 **/
@ApiModel
@Data
public class ReqAbnormalSlotDataByPageDto extends BaseQueryDto {

    /** 序列号 */
    private static final long  serialVersionUID = -5308774071126171980L;

    /** 以当前时间进行排序 */
    public static final String SORT_TYPE        = "cur_date";

    /** 升序排序 */
    public static final String ORDER_TYPE       = "asc";

    /**
     * 降序排序
     */
    public static final String ORDER_TYPE_DESC = "desc";

    /**查询app数据*/
    public static final Integer QUERY_APP_DATA       = 0;

    /**查询广告位数据*/
    public static final Integer QUERY_SLOT_DATA       = 1;


    /** 开始时间 */
    @ApiModelProperty(value = "开始时间", required = true)
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @NotNull(message = "开始日期不能为空")
    private Date               startDate;

    /** 结束时间 */
    @ApiModelProperty(value = "结束时间", required = true)
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @NotNull(message = "结束日期不能为空")
    private Date               endDate;

    @ApiModelProperty(value = "广告位ID")
    private Long    slotId;

    @ApiModelProperty(value = "广告位名称")
    private String  slotName;

    @ApiModelProperty(value = "媒体ID")
    private Long    appId;

    @ApiModelProperty(value = "媒体名称")
    private String  appName;

    @ApiModelProperty(value = "媒体账号ID")
    private Long    mediaId;

    @ApiModelProperty(value = "审核状态")
    private Integer    auditStatus;

    @ApiModelProperty(value = "是否固定计费模式 1-是 0-否")
    private Integer    isFixed;

    private Date curDate;

}
