/**
 * Project Name:media-api File Name:RspSlotDataStatisticsDto.java Package Name:cn.com.duiba.tuia.media.api.dto.rsp
 * Date:2016年10月13日下午8:20:08 Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.ssp.center.api.dto.abnormal;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * @Author zhangliwei
 * @Description  广告位异常返回数据
 * @Date 22:04 2020-03-04
 * @Param
 * @return
 **/
@Data
@ApiModel
public class RspAbnormalSlotDataDto implements Serializable {

    /**
     * 序列号
     */
    private static final long serialVersionUID = -7019648321036508754L;

    /**
     * 广告位ID.
     */
    @ApiModelProperty(value = "广告位ID")
    private Long slotId;

    /**
     * 广告位名称.
     */
    @ApiModelProperty(value = "广告位名称")
    private String slotName;

    /**
     * APPID.
     */
    @ApiModelProperty(value = "媒体ID")
    private Long appId;

    /**
     * APP名称.
     */
    @ApiModelProperty(value = "媒体名称")
    private String appName;

    /**广告位曝光PV*/
    @ApiModelProperty(value = "广告位曝光PV")
    private Long actExposeCount;

    /**广告位点击PV*/
    @ApiModelProperty(value = "广告位点击PV")
    private Long actClickCount;

    /**广告位点击UV*/
    @ApiModelProperty(value = "广告位点击UV")
    private Long actClickUv;

    /**计费方式*/
    @ApiModelProperty(value = "计费方式")
    private Integer chargeType;

    /**计费单价*/
    @ApiModelProperty(value = "计费单价")
    private Long slotUvPrice;

    /**当天日期*/
    @ApiModelProperty(value = "日期")
    private String curDate;

    /**审核状态*/
    @ApiModelProperty(value = "审核状态")
    private Integer auditStatus;

}
