/**
 * Project Name:media-biz<br/>
 * File Name:AdsenseDto.java<br/>
 * Package Name:cn.com.duiba.tuia.media.domain<br/>
 * Date:2016年9月26日下午5:05:11<br/>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.ssp.center.api.dto.abnormal;

import cn.com.duiba.tuia.ssp.center.api.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * @Author zhangliwei
 * @Description  管理端返回前端列表数据
 * @Date 22:59 2020-03-04
 * @Param
 * @return
 **/
@Data
@ApiModel
public class UploadDataAndAuditDetailDto extends ManualUploadDataDto {

    /**审核表ID*/
    private Long id;

    /**广告位名称*/
    private String slotName;

    /**广告位曝光PV*/
    @ApiModelProperty(value = "待审记录数", required = false)
    private Integer count;

    /**广告位点击PV*/
    @ApiModelProperty(value = "广告位访问PV", required = false)
    private Long slotRequestPv;

    /**广告位点击UV*/
    @ApiModelProperty(value = "广告位访问UV", required = false)
    private Long slotRequestUv;

    /**审核状态*/
    private Integer auditStatus;

    @ApiModelProperty(value = "拒绝原因", required = false)
    private String refuseReason;
}
