package cn.com.duiba.tuia.ssp.center.api.dto;

import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

public class MaterialDto implements Serializable {
    private static final long serialVersionUID = 8180020066933617725L;

    /** 素材图片 类型 0-静态素材. */
    public static final int    PICTURE_TYPE_STATIC             = 0;
    /** 素材图片 类型 1-动态素材 */
    public static final int    PICTURE_TYPE_DYNAMIC            = 1;
    /**素材图片 类型 3-视频素材*/
    public static final int    PICTURE_TYPE_VIDEO              = 3;

    private Long id;

    private Date gmtCreate;

    private Date gmtModified;

    private String title;

    private String content;

    private String pictureType;

    private String pictureGroup;

    private Long msId;

    private String msName;

    private String remark;

    private String md5;

    private String designer;

    /**
     * 审核状态
     */
    private Integer auditState;

    /**
     * 审核消息
     */
    private String auditMsg;

    /**
     * 审核图片
     */
    private String auditUrl;

    /**
     * 最后审核提交人
     */
    private Long lastManagerId;

    /**
     * 最后审核提交时间
     */
    private Date submitAuditTime;
    /**
     * 图片属性检索字段
     */
    private String pictureVal;


    public String getPictureVal() {
        if(StringUtils.isNotBlank(this.content)){
            List<MCDto> mcDtoList = JSONObject.parseArray(this.content, MCDto.class);
            for (MCDto mdl : mcDtoList) {
                this.pictureVal=mdl.getHeight() + "*" + mdl.getWidth();
            }
        }
        return pictureVal;
    }


    public void setPictureVal(String pictureVal) {
        this.pictureVal = pictureVal;
    }

    /** 素材开启状态，0：关闭，1：开启，不传：全部 */
    private Integer enableStatus;
    /** 素材定时开关，1：开启，0：关闭 */
    private Integer regularTimeStatus;
    /** 素材定时生效时间 */
    private Long regularTimeStart;
    /** 素材定时失效时间 */
    private Long regularTimeEnd;
    /** 素材媒体定向开关，1：开启，0：关闭 */
    private Integer mediaLimitStatus;
    /** 素材定向的媒体ID列表 */
    private List<Long> mediaAppIdList;
    /** 素材标签集合 */
    private List<String> tagIdList;
    /** 素材定向的媒体列表 */
    private List<MediaAppDto> mediaAppList;

    /** 素材大小 */
    private Long pictureSize;

    /** 素材文案-标题 */
    private String extTitle;
    /** 素材文案-描述 */
    private String extDesc;
    /** 裁切状态 0：非裁切素材 1：裁切素材 **/
    private Integer cutState;

    /** 曝光PV **/
    private Long exposeCount;
    /** CTR(点击量/曝光量) **/
    private Double ctr;

    /** 是否添加至优选库(-1:全部素材 1:已添加 0:未添加) **/
    private Integer preferredStatus;

    public String getDesigner() {
        return designer;
    }

    public void setDesigner(String designer) {
        this.designer = designer;
    }

    public String getMd5() {
        return md5;
    }

    public void setMd5(String md5) {
        this.md5 = md5;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title == null ? null : title.trim();
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content == null ? null : content.trim();
    }

    public String getPictureType() {
        return pictureType;
    }

    public void setPictureType(String pictureType) {
        this.pictureType = pictureType == null ? null : pictureType.trim();
    }

    public String getPictureGroup() {
        return pictureGroup;
    }

    public void setPictureGroup(String pictureGroup) {
        this.pictureGroup = pictureGroup == null ? null : pictureGroup.trim();
    }

    public Long getMsId() {
        return msId;
    }

    public void setMsId(Long msId) {
        this.msId = msId;
    }

    public String getMsName() {
        return msName;
    }

    public void setMsName(String msName) {
        this.msName = msName;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark == null ? null : remark.trim();
    }

    public Integer getAuditState() {
        return auditState;
    }

    public void setAuditState(Integer auditState) {
        this.auditState = auditState;
    }

    public String getAuditMsg() {
        return auditMsg;
    }

    public void setAuditMsg(String auditMsg) {
        this.auditMsg = auditMsg;
    }

    public Long getLastManagerId() {
        return lastManagerId;
    }

    public void setLastManagerId(Long lastManagerId) {
        this.lastManagerId = lastManagerId;
    }

    public Date getSubmitAuditTime() {
        return submitAuditTime;
    }

    public void setSubmitAuditTime(Date submitAuditTime) {
        this.submitAuditTime = submitAuditTime;
    }

    public String getAuditUrl() {
        return auditUrl;
    }

    public void setAuditUrl(String auditUrl) {
        this.auditUrl = auditUrl;
    }

    public Integer getEnableStatus() {
        return enableStatus;
    }

    public void setEnableStatus(Integer enableStatus) {
        this.enableStatus = enableStatus;
    }

    public Integer getRegularTimeStatus() {
        return regularTimeStatus;
    }

    public void setRegularTimeStatus(Integer regularTimeStatus) {
        this.regularTimeStatus = regularTimeStatus;
    }

    public Long getRegularTimeStart() {
        return regularTimeStart;
    }

    public void setRegularTimeStart(Long regularTimeStart) {
        this.regularTimeStart = regularTimeStart;
    }

    public Long getRegularTimeEnd() {
        return regularTimeEnd;
    }

    public void setRegularTimeEnd(Long regularTimeEnd) {
        this.regularTimeEnd = regularTimeEnd;
    }

    public Integer getMediaLimitStatus() {
        return mediaLimitStatus;
    }

    public void setMediaLimitStatus(Integer mediaLimitStatus) {
        this.mediaLimitStatus = mediaLimitStatus;
    }

    public List<Long> getMediaAppIdList() {
        return mediaAppIdList;
    }

    public void setMediaAppIdList(List<Long> mediaAppIdList) {
        this.mediaAppIdList = mediaAppIdList;
    }

    public List<String> getTagIdList() {
        return tagIdList;
    }

    public void setTagIdList(List<String> tagIdList) {
        this.tagIdList = tagIdList;
    }

    public List<MediaAppDto> getMediaAppList() {
        return mediaAppList;
    }

    public void setMediaAppList(List<MediaAppDto> mediaAppList) {
        this.mediaAppList = mediaAppList;
    }

    public Long getPictureSize() {
        return pictureSize;
    }

    public void setPictureSize(Long pictureSize) {
        this.pictureSize = pictureSize;
    }

    public String getExtTitle() {
        return extTitle;
    }

    public void setExtTitle(String extTitle) {
        this.extTitle = extTitle;
    }

    public String getExtDesc() {
        return extDesc;
    }

    public void setExtDesc(String extDesc) {
        this.extDesc = extDesc;
    }

    public Integer getCutState() {
        return cutState;
    }

    public void setCutState(Integer cutState) {
        this.cutState = cutState;
    }

    public Long getExposeCount() {
        return exposeCount;
    }

    public void setExposeCount(Long exposeCount) {
        this.exposeCount = exposeCount;
    }

    public Double getCtr() {
        return ctr;
    }

    public void setCtr(Double ctr) {
        this.ctr = ctr;
    }

    public Integer getPreferredStatus() {
        return preferredStatus;
    }

    public void setPreferredStatus(Integer preferredStatus) {
        this.preferredStatus = preferredStatus;
    }
}