/**
 * Project Name:media-api File Name:RspSlotDataStatisticsDto.java Package Name:cn.com.duiba.tuia.media.api.dto.rsp
 * Date:2016年10月13日下午8:20:08 Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.ssp.center.api.dto;

import lombok.Data;

import java.io.Serializable;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * @Author zhangliwei
 * @Description  广告位异常返回数据
 * @Date 22:04 2020-03-04
 * @Param
 * @return
 **/
@Data
public class RspAbnormalSlotDataDto implements Serializable {

    /**
     * 序列号
     */
    private static final long serialVersionUID = -7019648321036508754L;

    /**
     * 广告位ID.
     */
    private Long slotId;

    /**
     * 广告位名称.
     */
    private String slotName;

    /**
     * 广告位类型.
     */
    private Integer slotType;

    /**
     * 广告位规格名称
     */
    private String msName;

    /**
     * 曝光量.
     */
    private Long exposureCount;

    /**
     * 广告券曝光量.
     */
    private Long advertExposureCount;

    /**
     * 广告券Cpm.
     */
    private Long advertCpm;

    /**
     * 点击率
     */
    private Float clickRate;

    /**
     * 点击数.
     */
    private Long clickCount;

    /**
     * 预计收入.
     */
    private Long consumeTotal;

    /**
     * 预计收入.
     */
    private Long hzConsumeTotal;

    /**
     * 预计收入.
     */
    private Long hegsConsumeTotal;

    /**
     * 霍城兑捷预计收入.
     */
    private Long hcdjConsumeTotal;

    /**
     * 每一千次的有效价格.
     */
    private Long eCpm;

    /**
     * 点击单价.
     */
    private Long cpc;

    /**
     * 广告位成功响应数量
     */
    private Long actSucResponseCount;

    /**
     * 广告位访问pv
     */
    private Long slotRequestPv;

    /**
     * 广告位访问uv
     */
    private Long slotRequestUv;

    private Integer modifyStatus;

    /* ip访问量*/
    private Long ipRequestPvCount;

    /*  新客访问量(UV)  */
    private Long newRequestUvCount;

    /**
     * 媒体cpc=预计收益/点击量
     */
    private Long mediaCpc;
    /**
     * 媒体cpm=预计收益*1000/曝光量
     */
    private Long mediaCpm;
    /**
     * 每UV收益=预计收益/广告位访问UV
     */
    private Long mediaUvPrice;


    /**
     * 活动访问uv
     */
    private Long actRequestUv;


    /**
     * 次日留存
     */
    private Long morrowRetention;

    /**
     * 三日留存
     */
    private Long threeDaysRetention;

    /**
     * 七日留存
     */
    private Long sevenDaysRetention;


    /**
     * 三日ltv
     */
    private Long threeDaysLtv;

    /**
     *参与uv
     */
    private Long activityParticipationUv;


    /**
     * 参与率
     */
    private Float participationRate;


    /**
     * 查询区间结束日期广告位访问uv
     */
    private Long slotRequestUvEndDate;

    /**
     * 排序
     *
     * @param param
     * @param slotDataStatisticsList
     * @return
     */
    public static List<RspAbnormalSlotDataDto> listSort(ReqSlotLineStatisticsByPageDto param, List<RspAbnormalSlotDataDto> slotDataStatisticsList) {  //NOSONAR
        String sort = param.getSort();
        String order = param.getOrder();
        if (Objects.nonNull(sort) && Objects.nonNull(order)) {
            formatList(sort,slotDataStatisticsList);
            switch (sort) {
                case "exposureCount":
                    if (Objects.equals(order, "desc")) {
                        return slotDataStatisticsList.stream().sorted(Comparator.comparingLong(RspAbnormalSlotDataDto::getExposureCount).reversed()).collect(Collectors.toList());
                    } else {
                        return slotDataStatisticsList.stream().sorted(Comparator.comparingLong(RspAbnormalSlotDataDto::getExposureCount)).collect(Collectors.toList());
                    }
                case "clickCount":
                    if (Objects.equals(order, "desc")) {
                        return slotDataStatisticsList.stream().sorted(Comparator.comparingLong(RspAbnormalSlotDataDto::getClickCount).reversed()).collect(Collectors.toList());
                    } else {
                        return slotDataStatisticsList.stream().sorted(Comparator.comparingLong(RspAbnormalSlotDataDto::getClickCount)).collect(Collectors.toList());
                    }
                case "clickRate":
                    if (Objects.equals(order, "desc")) {
                        return slotDataStatisticsList.stream().sorted(Comparator.comparingDouble(RspAbnormalSlotDataDto::getClickRate).reversed()).collect(Collectors.toList());
                    } else {
                        return slotDataStatisticsList.stream().sorted(Comparator.comparingDouble(RspAbnormalSlotDataDto::getClickRate)).collect(Collectors.toList());
                    }
                case "consumeTotal":
                    if (Objects.equals(order, "desc")) {
                        return slotDataStatisticsList.stream().sorted(Comparator.comparingLong(RspAbnormalSlotDataDto::getConsumeTotal).reversed()).collect(Collectors.toList());
                    } else {
                        return slotDataStatisticsList.stream().sorted(Comparator.comparingLong(RspAbnormalSlotDataDto::getConsumeTotal)).collect(Collectors.toList());
                    }
                case "slotRequestPv":
                    if (Objects.equals(order, "desc")) {
                        return slotDataStatisticsList.stream().sorted(Comparator.comparingLong(RspAbnormalSlotDataDto::getSlotRequestUv).reversed()).collect(Collectors.toList());
                    } else {
                        return slotDataStatisticsList.stream().sorted(Comparator.comparingLong(RspAbnormalSlotDataDto::getSlotRequestUv)).collect(Collectors.toList());
                    }
                case "slotRequestUv":
                    if (Objects.equals(order, "desc")) {
                        return slotDataStatisticsList.stream().sorted(Comparator.comparingLong(RspAbnormalSlotDataDto::getSlotRequestUv).reversed()).collect(Collectors.toList());
                    } else {
                        return slotDataStatisticsList.stream().sorted(Comparator.comparingLong(RspAbnormalSlotDataDto::getSlotRequestUv)).collect(Collectors.toList());
                    }
                case "ipRequestPvCount":
                    if (Objects.equals(order, "desc")) {
                        return slotDataStatisticsList.stream().sorted(Comparator.comparingLong(RspAbnormalSlotDataDto::getIpRequestPvCount).reversed()).collect(Collectors.toList());
                    } else {
                        return slotDataStatisticsList.stream().sorted(Comparator.comparingLong(RspAbnormalSlotDataDto::getIpRequestPvCount)).collect(Collectors.toList());
                    }
                case "newRequestUvCount":

                    if (Objects.equals(order, "desc")) {
                        return slotDataStatisticsList.stream().sorted(Comparator.comparingLong(RspAbnormalSlotDataDto::getNewRequestUvCount).reversed()).collect(Collectors.toList());
                    } else {
                        return slotDataStatisticsList.stream().sorted(Comparator.comparingLong(RspAbnormalSlotDataDto::getNewRequestUvCount)).collect(Collectors.toList());
                    }
                case "mediaCpc":
                    if (Objects.equals(order, "desc")) {
                        return slotDataStatisticsList.stream().sorted(Comparator.comparingLong(RspAbnormalSlotDataDto::getMediaCpc).reversed()).collect(Collectors.toList());
                    } else {
                        return slotDataStatisticsList.stream().sorted(Comparator.comparingLong(RspAbnormalSlotDataDto::getMediaCpc)).collect(Collectors.toList());
                    }
                case "mediaCpm":
                    if (Objects.equals(order, "desc")) {
                        return slotDataStatisticsList.stream().sorted(Comparator.comparingLong(RspAbnormalSlotDataDto::getMediaCpm).reversed()).collect(Collectors.toList());
                    } else {
                        return slotDataStatisticsList.stream().sorted(Comparator.comparingLong(RspAbnormalSlotDataDto::getMediaCpm)).collect(Collectors.toList());
                    }
                case "mediaUvPrice":
                    if (Objects.equals(order, "desc")) {
                        return slotDataStatisticsList.stream().sorted(Comparator.comparingLong(RspAbnormalSlotDataDto::getMediaUvPrice).reversed()).collect(Collectors.toList());
                    } else {
                        return slotDataStatisticsList.stream().sorted(Comparator.comparingLong(RspAbnormalSlotDataDto::getMediaUvPrice)).collect(Collectors.toList());
                    }
                default:
                    break;
            }
        }
        return slotDataStatisticsList;
    }

    /**
     * 格式化数据
     *
     * @param sort
     * @param slotDataStatisticsList
     */
    private static void formatList(String sort, List<RspAbnormalSlotDataDto> slotDataStatisticsList) { //NOSONAR
        switch (sort) {
            case "exposureCount":
                slotDataStatisticsList.stream().forEach(o -> o.setExposureCount(Objects.isNull(o.getExposureCount()) ? 0 : o.getExposureCount()));
                break;
            case "clickCount":
                slotDataStatisticsList.stream().forEach(o -> o.setClickCount(Objects.isNull(o.getClickCount()) ? 0 : o.getClickCount()));
                break;
            case "clickRate":
                slotDataStatisticsList.stream().forEach(o -> o.setClickRate(Objects.isNull(o.getClickRate()) ? 0 : o.getClickRate()));
                break;
            case "consumeTotal":
                slotDataStatisticsList.stream().forEach(o -> o.setConsumeTotal(Objects.isNull(o.getConsumeTotal()) ? 0 : o.getConsumeTotal()));
                break;
            case "slotRequestPv":
                slotDataStatisticsList.stream().forEach(o -> o.setSlotRequestPv(Objects.isNull(o.getSlotRequestPv()) ? 0 : o.getSlotRequestPv()));
                break;
            case "slotRequestUv":
                slotDataStatisticsList.stream().forEach(o -> o.setSlotRequestUv(Objects.isNull(o.getSlotRequestUv()) ? 0 : o.getSlotRequestUv()));
                break;
            case "ipRequestPvCount":
                slotDataStatisticsList.stream().forEach(o -> o.setIpRequestPvCount(Objects.isNull(o.getIpRequestPvCount()) ? 0 : o.getIpRequestPvCount()));
                break;
            case "newRequestUvCount":
                slotDataStatisticsList.stream().forEach(o -> o.setNewRequestUvCount(Objects.isNull(o.getNewRequestUvCount()) ? 0 : o.getNewRequestUvCount()));
                break;
            case "mediaCpc":
                slotDataStatisticsList.stream().forEach(o -> o.setMediaCpc(Objects.isNull(o.getMediaCpc()) ? 0 : o.getMediaCpc()));
                break;
            case "mediaCpm":
                slotDataStatisticsList.stream().forEach(o -> o.setMediaCpm(Objects.isNull(o.getMediaCpm()) ? 0 : o.getMediaCpm()));
                break;
            case "mediaUvPrice":
                slotDataStatisticsList.stream().forEach(o -> o.setMediaUvPrice(Objects.isNull(o.getMediaUvPrice()) ? 0 : o.getMediaUvPrice()));
                break;
            default:
                break;
        }

    }
}
