/**
 * Project Name:media-api<br>
 * File Name:RemoteStatisticstBackendService.java<br>
 * Package Name:cn.com.duiba.tuia.media.api.remoteservice<br>
 * Date:2016年10月10日下午4:18:04<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */
package cn.com.duiba.tuia.ssp.center.api.remote;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.*;
import cn.com.duiba.tuia.ssp.center.api.dto.abnormal.ReqAbnormalSlotDataByPageDto;
import cn.com.duiba.tuia.ssp.center.api.dto.abnormal.UploadDataAndAuditDetailDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

/**
 * @Author zhangliwei
 * @Description  异常数据相关remote接口
 * @Date 16:41 2020-03-09
 * @Param
 * @return
 **/
@AdvancedFeignClient
public interface RemoteAbnormalSlotDataService {

    /**
     * @Author zhangliwei
     * @Description  根据日期查询广告位数据
     * @Date 16:50 2020-03-09
     * @Param [reqSlotLineStatisticsByPageDto]
     * @return cn.com.duiba.wolf.dubbo.DubboResult<java.util.List<cn.com.duiba.tuia.ssp.center.api.dto.MeidaActivitySlotStatisticsDto>>
     **/
    DubboResult<List<MeidaActivitySlotStatisticsDto>> selectByDate(
            ReqAbnormalSlotDataByPageDto reqAbnormalSlotDataByPageDto);


    /**
     * @Author zhangliwei
     * @Description  根据媒体上传数据更新广告位日数据
     * @Date 17:09 2020-03-10
     * @Param [req]
     * @return int
     **/
    int batchUpdateSlotDailyDataByMedia(List<ManualUploadDataDto> req);

    /**
     * @Author zhangliwei
     * @Description  批量插入待审核数据
     * @Date 20:30 2020-03-10
     * @Param [auditDetailDtos]
     * @return int
     **/
    int batchInsertAuditRecords(List<UploadDataAndAuditDetailDto> auditDetailDtos);
}
