/**
 * Project Name:media-biz<br/>
 * File Name:AdsenseDto.java<br/>
 * Package Name:cn.com.duiba.tuia.media.domain<br/>
 * Date:2016年9月26日下午5:05:11<br/>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.ssp.center.api.dto.abnormal;

import cn.com.duiba.tuia.ssp.center.api.dto.BaseDto;
import cn.com.duiba.tuia.ssp.center.api.dto.abnormal.UploadDataAndFeeDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * @Author zhangliwei
 * @Description  管理端返回前端列表数据
 * @Date 22:59 2020-03-04
 * @Param
 * @return
 **/
@Data
@ApiModel
public class RspManualUploadDataAuditDto extends BaseDto {

    /**审核表ID*/
    private Long id;

    /**媒体ID*/
    private Long appId;

    /**广告位ID*/
    private Long slotId;

    /**app名称*/
    private Long appName;

    /**广告位名称*/
    private String slotName;

    /**媒体运营名称*/
    private String managerName;

    /**当天日期*/
    @ApiModelProperty(value = "媒体最新提交时间", required = false)
    private Date lastSubmitDate;

    /**广告位曝光PV*/
    @ApiModelProperty(value = "待审记录数", required = false)
    private Integer count;

    /**广告位点击PV*/
    private Long actClickCountTotal;

    /**广告位点击UV*/
    private Long actClickUvTotal;

    /**审核状态*/
    private Integer auditStatus;

    @ApiModelProperty(value = "拒绝原因", required = false)
    private String refuseReason;
}
