package cn.com.duiba.tuia.ssp.center.api.remote;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.advertiser.AdvertiserThreePartyAuditDTO;
import cn.com.duiba.tuia.ssp.center.api.dto.advertiser.AdvertiserThreePartyAuditRsp;

import java.util.List;

@AdvancedFeignClient
public interface RemoteAdvertiserAuditService {

    /**
     * 获取所有广告主的审核状态
     * @return
     */
    List<AdvertiserThreePartyAuditDTO> getAllAdvertiserThreePartyAudit();

    /**
     * 查询广告主审核状态列表
     * @param adxType
     * @return
     */
    List<AdvertiserThreePartyAuditRsp> getAdvertiserAuditPage(Integer adxType);

    /**
     * 新增广告主审核状态
     */
    Integer saveAdvertiserAudit(AdvertiserThreePartyAuditDTO dto);

    /**
     * 修改广告主审核状态
     */
    Integer changeAdvertiserAudit(AdvertiserThreePartyAuditDTO dto);


    /**
     * 批量修改广告主审核状态
     */
    Integer batchChangeAdvertiserAudit(List<AdvertiserThreePartyAuditDTO> dto);
}
