package cn.com.duiba.tuia.ssp.center.api.dto;


import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.springframework.format.annotation.DateTimeFormat;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * ClassName:SlotStatisticsDataReq <br/>
 * Function: 广告位数据统计 <br/>
 * Date: 2016年12月21日 下午2:25:37 <br/>
 *
 * @author ZFZ
 * @version
 * @since JDK 1.6
 * @see
 */
@ApiModel
public class ReqSlotStatDailyByPage extends ReqPageQuery {

    /**序列号*/
    private static final long serialVersionUID = 3770712112337358087L;

    @ApiModelProperty(value = "广告位ID", required = false)
    private Long   slotId;

    @ApiModelProperty(value = "开始日期", required = true)
    @DateTimeFormat(pattern = "yyyy-MM")
    @NotNull(message = "开始日期不能为空")
    private String startDate;

    @ApiModelProperty(value = "结束日期", required = true)
    @DateTimeFormat(pattern = "yyyy-MM")
    @NotNull(message = "结束日期不能为空")
    private String endDate;

    @ApiModelProperty(value = "广告位名称(用作导出)", required = false)
    private String slotName;

    @ApiModelProperty(value = "媒体ID", required = false)
    private Long  appId;

    @ApiModelProperty(value = "账号ID", required = false)
    private Long  mediaId;
    
    @ApiModelProperty(value = "数据来源", required = false)
    private Integer dataSource;

    @ApiModelProperty(value = "标签id", required = false)
    private Long     tagId;

    @ApiModelProperty(value = "标签模块类型：1媒体行业，2媒体流量，3广告位性质", required = false)
    private Integer     tagBlock;

    @ApiModelProperty(value = "广告位ID", required = false)
    private List<Long> slotIds;

    @ApiModelProperty(value = "appId", required = false)
    private List<Long> appIds;

    /** The app name. */
    @ApiModelProperty(value = "媒体名称(用作导出)", required = false)
    private String appName;

    /**
     * 接入广告类型 0-互动广告 1-展示广告
     */
    @ApiModelProperty(value = "接入广告类型", required = false)
    private Integer slotAccessType;
    /**
     * slotId.
     *
     * @return the slotId
     * @since JDK 1.6
     */
    public Long getSlotId() {
        return slotId;
    }

    /**
     * slotId.
     *
     * @param slotId the slotId to set
     * @since JDK 1.6
     */
    public void setSlotId(Long slotId) {
        this.slotId = slotId;
    }

    /**
     * startDate.
     *
     * @return the startDate
     * @since JDK 1.6
     */
    public String getStartDate() {
        return startDate;
    }

    /**
     * startDate.
     *
     * @param startDate the startDate to set
     * @since JDK 1.6
     */
    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    /**
     * endDate.
     *
     * @return the endDate
     * @since JDK 1.6
     */
    public String getEndDate() {
        return endDate;
    }

    /**
     * endDate.
     *
     * @param endDate the endDate to set
     * @since JDK 1.6
     */
    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    /**
     * slotName.
     *
     * @return the slotName
     * @since JDK 1.6
     */
    public String getSlotName() {
        return slotName;
    }

    /**
     * slotName.
     *
     * @param slotName the slotName to set
     * @since JDK 1.6
     */
    public void setSlotName(String slotName) {
        this.slotName = slotName;
    }

    /**
     * appId.
     *
     * @return the appId
     * @since JDK 1.6
     */
    public Long getAppId() {
        return appId;
    }

    /**
     * appId.
     *
     * @param appId the appId to set
     * @since JDK 1.6
     */
    public void setAppId(Long appId) {
        this.appId = appId;
    }
    
    public Integer getDataSource() {
        return dataSource;
    }
    
    public void setDataSource(Integer dataSource) {
        this.dataSource = dataSource;
    }

    public Long getMediaId() {
        return mediaId;
    }

    public void setMediaId(Long mediaId) {
        this.mediaId = mediaId;
    }

    public Long getTagId() {
        return tagId;
    }

    public void setTagId(Long tagId) {
        this.tagId = tagId;
    }

    public Integer getTagBlock() {
        return tagBlock;
    }

    public void setTagBlock(Integer tagBlock) {
        this.tagBlock = tagBlock;
    }

    public List<Long> getSlotIds() {
        return slotIds;
    }

    public void setSlotIds(List<Long> slotIds) {
        this.slotIds = slotIds;
    }

    public List<Long> getAppIds() {
        return appIds;
    }

    public void setAppIds(List<Long> appIds) {
        this.appIds = appIds;
    }

    public String getAppName() {
        return appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public Integer getSlotAccessType() {
        return slotAccessType;
    }

    public void setSlotAccessType(Integer slotAccessType) {
        this.slotAccessType = slotAccessType;
    }

    @Override
    public String toString() {

        return ToStringBuilder.reflectionToString(this);
    }
}
