package cn.com.duiba.tuia.ssp.center.api.dto.advertiser;

import cn.com.duiba.tuia.ssp.center.api.dto.BaseQueryDto;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

@Data
public class AdvertiserThreePartyAuditStatusReq extends BaseQueryDto {

    private static final long serialVersionUID = 3831443832799643264L;

    /**
     * 广告主id
     */
    private Long advertiserId;

    /**
     * adx类型
     */
    @NotNull(message = "adx类型不能为空")
    private Integer adxType;

    /**
     * 审核状态：1.待审核 2.审核通过 3.审核不通过
     */
    private Integer auditStatus;

    /**
     * 起始时间
     */
    private String startDate;

    /**
     * 终止时间
     */
    private String endDate;

}
