package cn.com.duiba.tuia.ssp.center.api.remote;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.advertiser.*;

import java.util.List;

@AdvancedFeignClient
public interface RemoteAdvertiserThreePartyAuditStatusService {

    /**
     * 获取所有广告主的审核状态
     * @return
     */
    List<AdvertiserThreePartyAuditStatusDTO> getAllAdvertiserThreePartyAudit();

    /**
     * 根据adxType获取所有广告主的审核状态
     * @return
     */
    List<AdvertiserThreePartyAuditStatusDTO> getAdvertiserThreePartyAuditByAdxType(Integer adxType);

    /**
     * 查询广告主审核状态列表
     * @param adxType
     * @return
     */
    List<AdvertiserThreePartyAuditRsp> getAdvertiserAuditPage(Integer adxType);

    /**
     * 新增广告主审核状态
     */
    Integer saveAdvertiserAudit(AdvertiserThreePartyAuditStatusDTO dto);

    /**
     * 修改广告主审核状态
     */
    Integer changeAdvertiserAuditStatus(AdvertiserThreePartyAuditStatusDTO dto);


    /**
     * 批量修改广告主审核状态
     */
    Integer batchChangeAdvertiserAuditStatus(List<AdvertiserThreePartyAuditStatusDTO> dto);

    /**
     * 查询第三方广告主审核列表
     * @param req
     * @return
     */
    List<AdvertiserThreePartyAuditStatusRsp> getAdvertiserThreePartyAuditStatus(AdvertiserThreePartyAuditStatusReq req);

    /**
     * 获取广告主审核状态
     * @param req
     * @return
     */
    //List<AdvertiserThreePartyAuditStatusRsp> updateAdvertiserThreePartyAuditStatus(AdvertiserThreePartyAuditStatusQueryReq req);

    /**
     * 查询某个adx类型下面的广告主状态
     * @param req
     * @return
     */
    List<AdvertiserThreePartyAuditStatusDTO> getAdvertiserThreePartyAuditStatusById(AdvertiserThreePartyAuditStatusQueryReq req);
}
