package cn.com.duiba.tuia.ssp.center.api.remote;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.*;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.Collection;
import java.util.List;

/**
 * 媒体提现单service
 * 
 *
 */
@AdvancedFeignClient
public interface RemoteMediaPreSettleOrderService {

    /**
     *  根据id查询一条提现单记录
     * @param id
     * @return
     */
    DubboResult<MediaCashOrderDto>    getOrderById(Long id);

    /**
     *
     * getOrdersList:(查询提现明细列表). <br/>
     *
     * @param param
     * @author guyan
     * @return
     * @since JDK 1.6
     */
    DubboResult<List<MediaCashOrderDto>>   getPreSettleOrdersList(ReqCashDetail param);

    /**
     *
     * getCashOrdersCount:(查询提现明细). <br/>
     *
     * @param param
     * @author guyan
     * @return
     * @since JDK 1.6
     */
    DubboResult<Integer>  getPreSettleOrdersCount(ReqCashDetail param);


    /**
     * updateCashRequirementStatus:更新请款状态. <br/>
     *
     * @author Administrator
     * @param id
     * @return
     * @since JDK 1.6
     */
    DubboResult<Integer> updateCashRequirementStatus(Long id);

    /**
     * 提现单审批
     *
     * @param mediaCashOrderDto
     * @param auditor
     * @return
     */
    DubboResult<Boolean>  updatePreSettleOrderStatus(MediaCashOrderDto mediaCashOrderDto, String auditor);

    /**
     *  根据提现单查询一条提现单记录
     * @param cashOrderId
     * @return
     */
    DubboResult<MediaCashOrderDto> getOrderByCashOrderId(Long cashOrderId);

    /**
     * 查询提现明细数目，包含合同类型
     */
    Integer getPreSettleOrdersCountWithContractStatus(ReqCashDetail param);

    /**
     * 查询提现明细列表，包含合同类型
     */
    List<MediaCashOrderDto>  getPreSettleOrdersListWithContractStatus(ReqCashDetail param);

    /**
     * 根据提现单号查询发票列表
     * @param orderId 提现单号
     * @return
     */
    DubboResult<List<MediaCashBillDto>> getBillsByOrderId(Long orderId);
}
