/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.ssp.center.api.dto;

import cn.com.duiba.tuia.ssp.center.api.constant.SSPErrorCode;
import java.io.Serializable;

public class Result<T>
implements Serializable {
    private static final long serialVersionUID = -1467576157657126613L;
    private T data;
    private String code;
    private String desc;

    public static <T> Result<T> success(T data) {
        Result<T> result = new Result<T>();
        result.setData(data);
        result.setCode(SSPErrorCode.SSP_000000.getCode());
        result.setDesc(SSPErrorCode.SSP_000000.getDesc());
        return result;
    }

    public static <T> Result<T> error(String code, String desc) {
        Result<T> result = new Result<T>();
        result.setCode(code);
        result.setDesc(desc);
        return result;
    }

    public static <T> Result<T> error(SSPErrorCode errorCode) {
        Result<T> result = new Result<T>();
        result.setCode(errorCode.getCode());
        result.setDesc(errorCode.getDesc());
        return result;
    }

    public boolean isSuccess() {
        return SSPErrorCode.SSP_000000.getCode().equals(this.code);
    }

    public T getData() {
        return this.data;
    }

    public String getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setData(T data) {
        this.data = data;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Result)) {
            return false;
        }
        Result other = (Result)o;
        if (!other.canEqual(this)) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        String this$code = this.getCode();
        String other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
            return false;
        }
        String this$desc = this.getDesc();
        String other$desc = other.getDesc();
        return !(this$desc == null ? other$desc != null : !this$desc.equals(other$desc));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Result;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        String $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        String $desc = this.getDesc();
        result = result * 59 + ($desc == null ? 43 : $desc.hashCode());
        return result;
    }

    public String toString() {
        return "Result(data=" + this.getData() + ", code=" + this.getCode() + ", desc=" + this.getDesc() + ")";
    }
}

