package cn.com.duiba.tuia.ssp.center.api.constant;

import java.util.Arrays;
import java.util.Objects;

/**
 * Created by ZhangShun at 2020/4/25
 */
public enum SpecificationTemplateTypeEnum {

    CUSTOM(0, "自定义"),
    BOTTOM_PIC(1, "上文下图"),
    RIGHT_PIC(2, "左文右图"),
    LEFT_PIC(3, "左图右文"),
    THREE_PIC(4, "三图");

    private Integer type;

    private String name;

    SpecificationTemplateTypeEnum(Integer type, String name) {
        this.type = type;
        this.name = name;
    }

    public Integer getType() {
        return type;
    }

    public String getName() {
        return name;
    }

    public static String getNameByType(Integer type) {
        return Arrays.stream(SpecificationTemplateTypeEnum.values())
                .filter(v -> Objects.equals(v.getType(), type))
                .map(SpecificationTemplateTypeEnum::getName)
                .findFirst().orElse("");
    }

    public static String getTemplateTypeMsName(String sceneDesc, String spec) {
        return getTemplateTypeMsName(sceneDesc, spec, null, null, null);
    }

    public static String getTemplateTypeMsName(String sceneDesc, String spec, Integer templateType, Integer imageWidth, Integer imageHeight) {
        // 兼容老数据
        if (Objects.isNull(templateType) || Objects.equals(templateType, 0)) {
            if (Objects.equals(imageWidth, 225) && Objects.equals(imageWidth, 140)) {
                return sceneDesc+"(" + SpecificationTemplateTypeEnum.RIGHT_PIC.getName() + ":" + spec + ")";
            } else if (Objects.equals(imageHeight, 700) && Objects.equals(imageHeight, 280)) {
                return sceneDesc+"(" + SpecificationTemplateTypeEnum.BOTTOM_PIC.getName() + ":" + spec + ")";
            }
        }
        String desc = SpecificationTemplateTypeEnum.getNameByType(templateType);
        return sceneDesc+"(" + desc + ":" + spec + ")";
    }

}
