package cn.com.duiba.tuia.ssp.center.api.remote;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.*;
import cn.com.duiba.tuia.ssp.center.api.dto.sdk.SdkAdxConfigDto;
import cn.com.duiba.tuia.ssp.center.api.dto.sdk.SdkAdxSpecConfigDto;
import cn.com.duiba.tuia.ssp.center.api.dto.sdk.SdkAdxStyleListDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;
import java.util.Map;

/**
 * @author xuyenan
 * @createTime 2016/12/26
 */
@AdvancedFeignClient
public interface RemoteMaterialSpecificationBackendService {

    /**
     * 查询广告规格列表
     * 
     * @param req 查询条件
     * @return 广告规格列表
     */
    DubboResult<PageResultDto<RspMaterialSpecificationDto>> getMaterialSpecificationList(ReqMaterialSpecificationDto req);

    /**
     * 删除规格
     * 
     * @param id 规格ID
     * @return Boolean
     */
    DubboResult<Boolean> deleteMaterialSpecification(Long id);

    /**
     * 获取规格明细
     * 
     * @param msId 规格ID
     * @return 规格明细
     */
    DubboResult<RspMaterialSpecificationDto> getMaterialSpecificationDetail(Long msId);

    /**
     * 添加/更新规格
     * 
     * @param req 规格
     * @return Boolean
     */
    DubboResult<Boolean> addMaterialSpecification(ReqMaterialSpecificationDto req);

    /**
     * 添加/更新规格
     *
     * @param req 规格
     * @return Boolean
     */
    DubboResult<Long> insertMaterialSpecification(ReqMaterialSpecificationDto req);

    /**
     * 规格定向
     * 
     * @param msId 规格ID
     * @param appIds 媒体ID列表
     * @param directStatus
     * @return Boolean
     */
    DubboResult<Boolean> msDirectToMediaApp(Long msId, List<Long> appIds, Integer directStatus);

    /**
     * 获取规格定向的媒体列表
     * 
     * @param msId 规格ID
     * @return 媒体列表
     */
    DubboResult<List<MediaAppDto>> getMsDirectedMediaApp(Long msId);

    /**
     * 通过ID列表获取规格名称列表
     * 
     * @param ids 规格ID列表
     * @return MAP
     */
    DubboResult<Map<Long, String>> getMsNameByIds(List<Long> ids);

    /**
     * 通过ID列表获取规格名称列表
     *
     * @param ids 规格ID列表
     * @return MAP
     */
    DubboResult<Map<Long, NameAndTypeDto>> getMsNameTemplateTypeByIds(List<Long> ids);

    /**
     * 新素材曝光量达2000后更改状态
     *
     * @param materialId 素材ID
     * @return Boolean
     */
    DubboResult<Boolean> changeMsItemContentStatus(Long materialId);

    /**
     * getMsImageUrl:(获取素材地址). <br/>
     *
     * @param msId
     * @return
     * @since JDK 1.6
     */
    DubboResult<Map<Long, String>> getMsImageUrl(List<Long> msId);
    
    //获取素材库图片地址
    DubboResult<Map<Long, String>> getSckImageUrl(List<Long> sckIds);

    /**
     * getMsIdByName:(通过广告位规格查询广告位规格ID). <br/>
     *
     * @param msName
     * @return
     * @since JDK 1.6
     */
    DubboResult<List<Long>> getMsIdByName(String msName);
    
    /**
     * 
     * 通过广告位ID 查询活动素材ctr
     *
     * @author guyan
     * @param slotId
     * @return
     * @since JDK 1.6
     */
    DubboResult<List<MaterialCtrDto>> getMaterialCtrBySlotId(Long slotId);

    DubboResult<List<RspMaterialSpecificationDto>> getByIds(List<Long> ids);

    DubboResult<List<Long>> getMsIdsExceptTheMediaApp(Long mediaId);

    DubboResult<List<Long>> getMsIdsByMediaApp(Long mediaId);

    List<RspMaterialSpecificationItemDto> getByWithAndHeight(Integer imageWidth, Integer imageHeight);

    RspMaterialSpecificationItemDto getLatestByWithAndHeight(Integer imageWidth, Integer imageHeight);
    
    List<RspMaterialSpecificationItemDto> selectNoDeleteByWithAndHeight(Integer imageWidth, Integer imageHeight,Long msId);

    RspMaterialSpecificationDto selectLastItemDtoByIds(List<Long> ids);

    RspMaterialSpecificationItemDto selectMaterialSpecificationItemByMsId(Long msId);

    RspMaterialSpecificationItemDto getMaterialSpecificationItemById(Long id);

    /**
     * @Author zhangliwei
     * @Description  根据规格ID查询所有与当前规格宽高一致的所有规格数据
     * @Date 15:48 2019-12-06
     * @Param []
     * @return java.util.List<cn.com.duiba.tuia.ssp.center.api.dto.RspMaterialSpecificationItemDto>
     **/
    List<MaterialCutSpecificationDto> selectNoDeleteByMsId(Long msId);

    /**
     * @Autor liujainxue
     * @param sceneType
     * @param sckType
     * @return
     */
    public  List<MaterialCutSpecificationDto> getListBySceneTypeAndSckType(Integer sceneType,Integer sckType);

    public List<RspMaterialSpecificationItemDto> getMaterialSpecificationItemDOS(List<Long> msIds);

    //sdk作为特殊的adx处理，查询ADX列表
    public List<SdkAdxConfigDto> findAdxList(Integer directMaterialType);

    //查询ADX样式内容
    public List<SdkAdxStyleListDto> findAdxStyle(Integer directMaterialType,Long adxId,Long typeId,Long styleId);

    //获取具体的样式
    public SdkAdxSpecConfigDto getAdxStyle(Long sckId);



    /**
     * 按"标准规格"或"自定义"查询规格列表
     *
     * @param req 查询条件
     * @return 广告规格列表
     */
    List<RspMaterialSpecificationDto> listStandardOrCustomSpecification(ReqMaterialSpecificationDto req);

    /**
     * 根据规格ID查询规格信息
     */
    RspMaterialSpecificationDto getStandardOrCustomSpecification(Long msId);
}
