/**
 * Project Name:media-api<br>
 * File Name:RemoteStatisticstBackendService.java<br>
 * Package Name:cn.com.duiba.tuia.media.api.remoteservice<br>
 * Date:2016年10月10日下午4:18:04<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */
package cn.com.duiba.tuia.ssp.center.api.remote;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.*;
import cn.com.duiba.tuia.ssp.center.api.dto.abnormal.*;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

/**
 * @Author zhangliwei
 * @Description  异常数据相关remote接口
 * @Date 16:41 2020-03-09
 * @Param
 * @return
 **/
@AdvancedFeignClient
public interface RemoteAbnormalSlotDataService {

    /**
     * @Author zhangliwei
     * @Description  根据日期查询广告位数据
     * @Date 16:50 2020-03-09
     * @Param [reqSlotLineStatisticsByPageDto]
     * @return cn.com.duiba.wolf.dubbo.DubboResult<java.util.List<cn.com.duiba.tuia.ssp.center.api.dto.MeidaActivitySlotStatisticsDto>>
     **/
    DubboResult<List<MeidaActivitySlotStatisticsDto>> selectByDate(
            ReqAbnormalSlotDataByPageDto reqAbnormalSlotDataByPageDto);


    /**
     * @Author zhangliwei
     * @Description  根据媒体上传数据更新广告位日数据
     * @Date 17:09 2020-03-10
     * @Param [req]
     * @return int
     **/
    int batchUpdateSlotDailyDataByMedia(List<ManualUploadDataDto> req);

    /**
     * @Author zhangliwei
     * @Description  批量插入待审核数据
     * @Date 20:30 2020-03-10
     * @Param [auditDetailDtos]
     * @return int
     **/
    int batchInsertAuditRecords(List<UploadDataAndAuditDetailDto> auditDetailDtos);


    /**
     * @Author zhangliwei
     * @Description  根据记录ID集合查询所有审核记录详情
     * @Date 15:44 2020-03-11
     * @Param [recordIds]
     * @return java.util.List<cn.com.duiba.tuia.ssp.center.api.dto.abnormal.UploadDataAndAuditDetailDto>
     **/
    List<UploadDataAndAuditDetailDto>  getAuditDetailsByRecordIds(List<Long> recordIds);


    /**
     * @Author zhangliwei
     * @Description  根据广告位ID集合查询所有审核记录详情
     * @Date 15:44 2020-03-11
     * @Param [slotIds]
     * @return java.util.List<cn.com.duiba.tuia.ssp.center.api.dto.abnormal.UploadDataAndAuditDetailDto>
     **/
    List<UploadDataAndAuditDetailDto>  getAuditDetailsBySlotIds(List<Long> slotIds);



    /**
     * @Author zhangliwei
     * @Description  根据广告位ID集合和时间区间查询所有记录
     * @Date 15:44 2020-03-11
     * @Param [slotIds]
     * @return java.util.List<cn.com.duiba.tuia.ssp.center.api.dto.abnormal.UploadDataAndAuditDetailDto>
     **/
    List<UploadDataAndAuditDetailDto>  getAuditDetailsByReq(ReqAbnormalAuditData req);

    /**
     * @Author zhangliwei
     * @Description  审核列表查询 广告位 对应待审核数量  最后提交时间
     * @Date 17:41 2020-03-11
     * @Param []
     * @return java.util.List<cn.com.duiba.tuia.ssp.center.api.dto.abnormal.RspManualUploadDataAuditDto>
     **/
    List<RspManualUploadDataAuditDto> getAuditSumList();

    /**
     * @Author zhangliwei
     * @Description  批量审核接口
     * @Date 18:54 2020-03-11
     * @Param [dto]
     * @return void
     **/
    void batchAudit(ReqBatchAuditDto dto);

    /**
     * @Author zhangliwei
     * @Description  广告位正常收入更新
     * @Date 10:07 2020-03-19
     * @Param [details]
     * @return boolean
     **/
    boolean batchUpdateNormalIncome(List<UploadDataAndAuditDetailDto> details);
}
