package cn.com.duiba.tuia.ssp.center.api.remote;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.SlotInfoDto;
import cn.com.duiba.tuia.ssp.center.api.dto.SlotInfoReq;
import cn.com.duiba.tuia.ssp.center.api.dto.SlotMsInfoDto;

import java.util.List;

@AdvancedFeignClient
public interface RemoteToAdvertService {

    /**
     * 广告位名称为左模糊查询,提供给广告线管理端使用,不支持req里面什么都不传
     * @param req
     * @return
     */
    List<SlotInfoDto> getSlotInfoListByReq(SlotInfoReq req);

    /**
     * 广告位名称为左模糊查询,提供给广告线管理端使用,不支持req里面什么都不传
     * v2版本:提供给广告管理端用,取消屏蔽标签优先级逻辑,返回所有屏蔽标签,优化部分广告位屏蔽策略查询不到问题
     * @param req
     * @return
     */
    List<SlotInfoDto> getSlotInfoListByReqV2(SlotInfoReq req);


    /**
     * 根据slotId 提供广告位对应的规格信息
     * @param slotId 广告位Id
     * @return 广告位对应的规格信息
     */
    SlotMsInfoDto getSlotMsInfo(Long slotId);
}
