package cn.com.duiba.tuia.ssp.center.api.constant;

import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/**
 * @author yuantong
 * @version 1.0
 * @since 2020-02-26 15:06
 */
@NoArgsConstructor
@AllArgsConstructor
public enum AdvertReviewStatusEnum {

    Init(0, "初始化"),
    AwaitReview(1, "待审核"),
    ReviewVia(2, "审核通过"),
    ReviewFailure(3, "审核拒接"),
    SystemOffline(4, "系统下线");

    public static final Map<Integer, String> ADVERT_REVIEW_STATUS_MAP;

    static {
        Map<Integer, String> temp = new HashMap<>(AdvertReviewStatusEnum.values().length, 1);
        for (AdvertReviewStatusEnum tag: AdvertReviewStatusEnum.values()) {
            temp.put(tag.getCode(), tag.getRemark());
        }
        ADVERT_REVIEW_STATUS_MAP = Collections.unmodifiableMap(temp);
    }

    /**
     * 标识码
     */
    @Getter
    private Integer code;

    /**
     * 备注
     */
    @Getter
    private String remark;

}
