/**
 * Project Name:media-api File Name:ReqMediaAppStatusDto.java Package Name:cn.com.duiba.tuia.media.api.dto.req
 * Date:2016年10月19日下午8:31:13 Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.ssp.center.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

import javax.validation.constraints.NotNull;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * ClassName:ReqMediaAppStatusDto <br/>
 * Function: 修改媒体app状态Dto. <br/>
 * Date: 2016年10月19日 下午8:31:13 <br/>
 * 
 * @author guyan
 * @see
 */
@ApiModel
public class ReqUpdateMediaAppVerifyStatusDto implements Serializable {

    /** 序列号 */
    private static final long serialVersionUID     = -7823268451467834867L;

    /** 修改成功标识 */
    public static final int   UPDATE_SUCCESS       = 1;

    /** 验证状态:0-待验证. */
    public static final int   MEDIA_APP_VALIDATING       = 0;
    
    /** 验证状态:1-已验证. */
    public static final int   MEDIA_APP_VALIDATED        = 1;

    /** 媒体Id */
    @ApiModelProperty(value = "媒体Id", required = true)
    @NotNull(message = "媒体Id不能为空")
    private Long              appId;

    /** 媒体审核状态 */
    @ApiModelProperty(value = "媒体验证状态", required = true)
    @NotNull(message = "媒体验证状态不能为空")
    private Integer           verifyStatus;

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

	public Integer getVerifyStatus() {
		return verifyStatus;
	}

	public void setVerifyStatus(Integer verifyStatus) {
		this.verifyStatus = verifyStatus;
	}

}
