package cn.com.duiba.tuia.ssp.center.api.remote;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.WeChatDomainItemRsp;
import cn.com.duiba.tuia.ssp.center.api.dto.WeChatDomainReq;
import cn.com.duiba.tuia.ssp.center.api.dto.WeChatProxyDomainItemRsp;
import cn.com.duiba.tuia.ssp.center.api.dto.WeChatProxyDomainReq;

import java.util.List;

/**
 * 微信小程序域名服务
 */
@AdvancedFeignClient
public interface RemoteWeChatDomainService {

    /**
     * 查询域名列表
     * @param weChatDomainReq
     * @return
     */
    List<WeChatDomainItemRsp> queryDomainList(WeChatDomainReq weChatDomainReq);

    /**
     * 条目数
     * @param weChatDomainReq
     * @return
     */
    int countDomainList(WeChatDomainReq weChatDomainReq);

    /**
     * 查询代理域名列表
     * @param weChatProxyDomainReq
     * @return
     */
    List<WeChatProxyDomainItemRsp> qyeryProxyDomainList(WeChatProxyDomainReq weChatProxyDomainReq);

    /**
     * 条目数
     * @param weChatProxyDomainReq
     * @return
     */
    int countProxyDomainList(WeChatProxyDomainReq weChatProxyDomainReq);

    /**
     * 添加域名
     * @param weChatDomainReq
     * @return
     */
    int saveDomainList(WeChatDomainReq weChatDomainReq);

    /**
     * 添加代理域名
     * @param weChatProxyDomainReq
     * @return
     */
    int saveProxyDomainList(WeChatProxyDomainReq weChatProxyDomainReq);

    /**
     * 修改域名
     * @param weChatDomainReq
     * @return
     */
    int modifyDomainList(WeChatDomainReq weChatDomainReq);

    /**
     * 修改代理域名
     * @param weChatProxyDomainReq
     * @return
     */
    int modifyProxyDomainList(WeChatProxyDomainReq weChatProxyDomainReq);

    /**
     * 删除域名
     * @param weChatDomainReq
     * @return
     */
    int removeDomainList(WeChatDomainReq weChatDomainReq);

    /**
     * 删除代理域名
     * @param weChatProxyDomainReq
     * @return
     */
    int removeProxyDomainList(WeChatProxyDomainReq weChatProxyDomainReq);


}
