package cn.com.duiba.tuia.ssp.center.api.remote.industryPenetration;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.remote.industryPenetration.dto.*;
import java.util.List;

/**
 * 行业渗透 RemoteService
 * @dateTime 2020-05-13 11:51:27
 * @author haitao.hua
 */
@AdvancedFeignClient
public interface RemoteIndustryPenetrationService {


    /**
     * 枚举清单
     * @return 处理结果
     */
    EnumListing enumListing() throws BizException;

    /**
     * 应用清单
     * @return 处理结果
     */
    List<AppListing> appListing() throws BizException;

    /**
     * 行业清单
     * @param paging 分页信息
     * @return 处理结果
     */
    PagingResult<IndustryListing> industryListing(GainPaging paging) throws BizException;

    /**
     * 媒体清单
     * @param paging 分页信息
     * @return 处理结果
     */
    PagingResult<MediaListing> mediaListing(GainPaging paging) throws BizException;

    /**
     * { 获取 } 详情信息
     * @param id 主键 Id
     * @param mark 应用信息标记 , "already" 值标对接应用 , “original” 值标记原始应用.
     * @return 处理结果
     */
    MediaApplication mediaDetail(Long id, String mark) throws BizException;

    /**
     * { 匹配 } 媒体信息
     * @param id 媒体 Id
     * @param appId 应用 Id
     * @return 处理结果
     */
    MediaApplication mediaMatch(Long id, String appId) throws BizException;

    /**
     * { 创建 or 更新 } 媒体信息
     * @param media 媒体信息
     * @return 处理结果
     */
    boolean mediaSaving(MediaApplication media) throws BizException;

}
