package cn.com.duiba.tuia.ssp.center.api.remote;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.*;

import java.util.List;

/**
 * 微信小程序域名服务
 */
@AdvancedFeignClient
public interface RemoteWeChatDomainService {

    /**
     * 查询域名列表
     * @param weChatDomainReq
     * @return
     */
    List<WeChatDomainItemRsp> queryDomainList(WeChatDomainReq weChatDomainReq);

    /**
     * 条目数
     * @param weChatDomainReq
     * @return
     */
    int countDomainList(WeChatDomainReq weChatDomainReq);

    /**
     * 查询代理域名列表
     * @param weChatProxyDomainReq
     * @return
     */
    List<WeChatProxyDomainItemRsp> qyeryProxyDomainList(WeChatProxyDomainReq weChatProxyDomainReq);

    /**
     * 条目数
     * @param weChatProxyDomainReq
     * @return
     */
    int countProxyDomainList(WeChatProxyDomainReq weChatProxyDomainReq);

    /**
     * 添加域名
     * @param weChatDomainReq
     * @return
     */
    int saveDomainList(WeChatDomainReq weChatDomainReq) throws BizException;

    /**
     * 添加代理域名
     * @param weChatProxyDomainReq
     * @return
     */
    int saveProxyDomainList(WeChatProxyDomainReq weChatProxyDomainReq);

    /**
     * 修改域名
     * @param weChatDomainReq
     * @return
     */
    int modifyDomainList(WeChatDomainReq weChatDomainReq) throws BizException;

    /**
     * 修改代理域名
     * @param weChatProxyDomainReq
     * @return
     */
    int modifyProxyDomainList(WeChatProxyDomainReq weChatProxyDomainReq);

    /**
     * 删除域名
     * @param weChatDomainReq
     * @return
     */
    int removeDomainList(WeChatDomainReq weChatDomainReq);

    /**
     * 删除代理域名
     * @param weChatProxyDomainReq
     * @return
     */
    int removeProxyDomainList(WeChatProxyDomainReq weChatProxyDomainReq);

    /**
     * 微信广告位域名列表
     * @return
     */
    List<WeChatSlotDomainRsp> querySlotDomainList();

    /**
     * 添加微信域名广告位
     * @param weChatSlotDomainReq
     * @return
     */
    int saveSlotDomainList(WeChatSlotDomainReq weChatSlotDomainReq);

    /**
     * 查询广告位下的域名 随机取一个
     * @param reverseProxyInfoReq
     * @return
     */
    WeChatSlotDomainDto getReverseProxyInfo(ReverseProxyInfoReq reverseProxyInfoReq);

    /**
     * 删除域名广告位
     * @param weChatSlotDomainReq
     * @return
     */
    int removeSlotDomainItem(WeChatSlotDomainReq weChatSlotDomainReq);

    /**
     * 修改域名广告位
     * @param weChatProxyDomainReq
     * @return
     */
    int modifyProxyDomainItem(WeChatProxyDomainReq weChatProxyDomainReq);

    /**
     * 查询告警列表
     * @return
     */
    List<WeChatDomainAlarmDto> queryAlarmList();

    /**
     * 保存告警信息
     * @param weChatDomainAlarmReq
     * @return
     */
    int saveAlarmList(WeChatDomainAlarmReq weChatDomainAlarmReq);
}
