package cn.com.duiba.tuia.ssp.center.api.constant;

/**
 * @Auther: fenglijun
 * @Date: 2019/8/9 10:24
 * @Description:
 */
public class NewMediaTestEnum {
    public enum StatusEnum {
        TESTING(0,"初始化测试中"),
        TEST_FINISHED(1,"测试结束"),
        TEST_SUCCESS(2,"测试完成"),
        IN_TEST(3,"测试中")
        ;

        private Integer value;

        private String desc;

        StatusEnum(Integer value, String desc) {
            this.value = value;
            this.desc = desc;
        }

        public Integer getValue() {
            return value;
        }

        public String getDesc() {
            return desc;
        }
    }

    public enum  AppMarkEnum {
        JOIN_TEST(1,"参加测试"),
        NOT_JOIN_TEST(2,"不参加测试");
        private Integer value;
        private String desc;

        AppMarkEnum(Integer value, String desc) {
            this.value = value;
            this.desc = desc;
        }
        public static AppMarkEnum getEnum(int index) {
            for(AppMarkEnum tEnum : values()) {
                if(tEnum.getValue() == index) {
                    return tEnum ;
                }
            }
            return null;
        }
        public Integer getValue() {
            return value;
        }

        public String getDesc() {
            return desc;
        }
    }


    public enum DataSourceEnum {
        MANUAL(1,"手动添加"),
        BACKFLOW(2,"数据回流");

        private Integer value;
        private String desc;

        DataSourceEnum(Integer value, String desc) {
            this.value = value;
            this.desc = desc;
        }

        public Integer getValue() {
            return value;
        }

        public String getDesc() {
            return desc;
        }
    }

    /**优先级枚举**/
    public enum PriorityEnum {
        NORMAL(0,"普通"),
        PRIVILEGED(1,"优先");

        private Integer value;
        private String desc;

        PriorityEnum(Integer value, String desc) {
            this.value = value;
            this.desc = desc;
        }

        public Integer getValue() {
            return value;
        }

        public String getDesc() {
            return desc;
        }
    }
}
