package cn.com.duiba.tuia.ssp.center.api.remote;

import java.util.List;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.PageResultDto;
import cn.com.duiba.tuia.ssp.center.api.dto.ProblemMenusDto;
import cn.com.duiba.tuia.ssp.center.api.dto.ReqProblemMenusDto;

/**
 * ClassName: RemoteProblemMenusService <br/>
 * Function: <br/>
 * Date: 2018年06月20日 下午5:04 <br/>
 *
 * @author lijian
 */
@AdvancedFeignClient
public interface RemoteProblemMenusService {

    /**
     * 新增常见问题记录
     * 
     * @param dto
     * @return
     */
    Integer insert(ProblemMenusDto dto);

    /***
     * 根据id删除常见问题记录
     * 
     * @param id
     * @return
     */
    Integer delProblemMenus(Long id);

    /***
     * 更新常见问题记录
     * 
     * @param dto
     * @return
     */
    Integer updateProblemMenus(ProblemMenusDto dto);

    /***
     * 获取所有问题类别
     *
     * @return
     */
    List<String> getProblemCategorys();

    /***
     * 分页查询查询常见问题记录
     *
     * @param req
     * @return
     */
    PageResultDto<ProblemMenusDto> getProblemMenusList(ReqProblemMenusDto req);

    /***
     * 获取配置常见问题菜单数据
     *
     * @return
     */
    List<ProblemMenusDto> getProblemCategoryBySort();

    /***
     * 获取常见问题菜单，用于web显示
     *
     * @return
     */
    List<ProblemMenusDto> getProblemMenusWebList();

    /***
     * 获取问题类别最大的序号
     *
     * @return
     */
    Integer getSortCategory();

    /***
     * 根据问题类别获取标题最大的序号
     *
     * @return
     */
    Integer getSortTitle(String problemCategory);

    /***
     * 根据id获取常见问题数据
     *
     * @return
     */
    ProblemMenusDto getById(Long id, Integer pageType);

}
