package cn.com.duiba.tuia.ssp.center.api.remote;

import java.util.List;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.AccountDayReportDto;
import cn.com.duiba.tuia.ssp.center.api.dto.ReqAccountDayReport;
import cn.com.duiba.tuia.ssp.center.api.dto.ReqAppDayBillByPage;
import cn.com.duiba.tuia.ssp.center.api.dto.ReqDayBillDetailByPage;
import cn.com.duiba.tuia.ssp.center.api.dto.ReqSlotDayBillByPage;
import cn.com.duiba.tuia.ssp.center.api.dto.ReqSlotLineStatisticsByPageDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

@AdvancedFeignClient
public interface RemoteAccountReportDayService {
    DubboResult<List<AccountDayReportDto>> selectAppDayBillList(ReqSlotLineStatisticsByPageDto reqSlotLineStatisticsByPageDto);

    DubboResult<List<AccountDayReportDto>> selectAppDayBillListGroupByCurDate(ReqSlotLineStatisticsByPageDto reqSlotLineStatisticsByPageDto);

    DubboResult<List<AccountDayReportDto>> selectLineData(ReqSlotLineStatisticsByPageDto reqSlotLineStatisticsByPageDto);

    DubboResult<List<AccountDayReportDto>> selectList(ReqAccountDayReport reqAccountDayReport);
    
    List<AccountDayReportDto> newSelectList(ReqAccountDayReport reqAccountDayReport);

    DubboResult<List<AccountDayReportDto>> selectAppDayBillByPage(ReqAppDayBillByPage reqAppDayBillByPage);

    DubboResult<List<AccountDayReportDto>> selectSlotDayBillByPage(ReqSlotDayBillByPage reqSlotDayBillByPage);

    DubboResult<Integer> selectAppDayBillAmount(ReqAppDayBillByPage reqAppDayBillByPage);

    DubboResult<Integer> selectSlotDayBillAmount(ReqSlotDayBillByPage reqSlotDayBillByPage);

    DubboResult<List<AccountDayReportDto>> selectDayBillDetail(ReqDayBillDetailByPage reqDayBillDetailByPage);

    DubboResult<Integer> selectDayBillDetailAmount(ReqDayBillDetailByPage reqDayBillDetailByPage);

    DubboResult<List<AccountDayReportDto>> selectSlotDayBillList(ReqSlotLineStatisticsByPageDto req);
    
    DubboResult<AccountDayReportDto> selectAppDayBillSum(ReqAppDayBillByPage req);
    
    DubboResult<AccountDayReportDto> selectDayBillSum(ReqDayBillDetailByPage req);
    
    DubboResult<AccountDayReportDto> selectSlotDayBillSum(ReqSlotDayBillByPage req);
    
    DubboResult<AccountDayReportDto> selecDayBillSum(ReqAccountDayReport req);

    DubboResult<List<AccountDayReportDto>> selectMonthBySlotIds(List<Long> slotIds, String date);
    
    /**
     * selectAccountConsumeTotal:(查询账户总金额). <br/>
     *
     * @author guyan
     * @param mediaId
     * @return
     */
    Long selectAccountConsumeTotal(Long mediaId,String date);
   
    /**
     * newSelectAppDayBillByPage:(查询媒体账单每日数据). <br/>
     *
     * @author guyan
     * @param reqAppDayBillByPage
     * @return
     */
    List<AccountDayReportDto> newSelectAppDayBillByPage(ReqAppDayBillByPage reqAppDayBillByPage);
}
