package cn.com.duiba.tuia.ssp.center.api.remote.mediumChangeNotice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.mediumChangeNotice.MediumChangeNoticeDto;

/**
 * 媒介消息变更
 */
@AdvancedFeignClient
public interface RemoteMediumChangeNoticeService  {
    /**
     * 注册对象
     * @param mediumChangeNoticeDto   注册对象
     */
     void attach(MediumChangeNoticeDto mediumChangeNoticeDto);

    /**
     * 获取媒介信息通过媒体Id 提供业务端轮询获取媒介信息(每60秒轮询一次)
     *
     * @param mediaId
     * @return
     */
     MediumChangeNoticeDto getMediumMsgByMediaId(Long mediaId);



     MediumChangeNoticeDto getMediumInfo(Long mediaId);

    /**
     * 媒体商务对接人
     * @param mediaId
     * @return
     */
     MediumChangeNoticeDto getMediumInfoV2(Long mediaId);

}
