package cn.com.duiba.tuia.ssp.center.api.remote;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.*;
import cn.com.duiba.wolf.dubbo.DubboResult;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

@AdvancedFeignClient
public interface RemoteMaterialService {

    DubboResult<Long> insert(MaterialDto record);

    DubboResult<Boolean> update(MaterialDto record);

    DubboResult<Boolean> updateMaterialDirect(MaterialDirectDto record);

    DubboResult<MaterialDirectAppDto> getDirectAppByMaterialId(Long id);

    DubboResult<Boolean> delete(Long id);

    DubboResult<List<MaterialDto>> listByPage(ReqMaterialDto param);

    DubboResult<List<MaterialDto>> getSimilarFatherList(ReqMaterialDto param);

    DubboResult<List<Long>> listIdByParam(String group, String type);

    DubboResult<Integer> countByParam(ReqMaterialDto param);

    DubboResult<Integer> countPidsByParam(ReqMaterialDto param);

    DubboResult<List<MaterialToActDto>> list4Act(Long id, String title, String group, String type, Long msId);

    List<MaterialToActDto> newList4Act(Long id, String title, String group, String type, Long msId, String designer);

    DubboResult<List<MaterialDto>> listByMd5(MaterialDto record);

    DubboResult<MaterialDto> selectById(Long id);

    List<Long> saveBatchMaterial(List<ReqMaterialDto> list);

    boolean submitAudit(Long managerId, Long materialId);

    List<MaterialForSlot> getListForSlot(Long slotId);

    List<MaterialForSlot> getListBySlot4DPA20(Long slotId);

    Integer getNumForSlot(Long slotId);

    boolean materialChange();

    List<Long> saveBatchMaterialConfig(List<ReqMaterialConfigDto> list);

    boolean transferMaterialGroupToTag();

    boolean updateMaterialTag(List<String> tagIdStringList, Long materialId);

    List<MaterialToActDto> newList4ActByReqMaterialDto(ReqMaterialDto reqMaterialDto);

    /**
     * 更新素材库（只更新素材库这一张表，即tb_material，慎用）
     *
     * @param id
     * @param pictureSize
     * @return
     */
    Boolean initPictureSize(Long id, Long pictureSize);

    /**
     * 查询出所有没有大小的素材（初始化素材大小时使用）
     *
     * @return
     */
    List<MaterialDto> queryMaterialNoSize();

    boolean updateMaterialTitleAndDesc(List<MaterialDto> materialDtos);

    /**
     * 获取裁切素材列表
     *
     * @param param 查询条件
     * @return 裁切素材列表
     */
    List<MaterialCutDto> listMaterialCut(ReqMaterialCutDto param);

    /**
     * 获取裁切素材总数
     *
     * @param param 查询条件
     * @return 裁切素材总数
     */
    Integer countMaterialCut(ReqMaterialCutDto param);

    /**
     * 批量保存裁切素材
     *
     * @param records    裁切素材列表
     * @param fillStatus 是否填充数据，1：是，0：否
     * @param managerId  审核员id
     * @return 新增素材id
     */
    List<Long> saveBatchMaterialCut(List<ReqMaterialCutStyleDto> records, Integer fillStatus, Long managerId);

    /**
     * 获取裁切目标尺寸列表
     *
     * @return 裁切目标尺寸列表
     */
    List<MaterialCutSpecificationDto> listMaterialCutSpecification();

    /**
     * 批量更新素材ids的投放状态
     * @param materialIds
     * @param enableStatus
     * @return
     */
    int batchUpdateEnableStatus(List<Long> materialIds, Integer enableStatus);

    /**
     * 是否可删除素材
     *
     * @param id 素材id
     * @return 删除结果
     */
    MaterialDeleteDto whetherDeleteMaterial(Long id);

    /**
     * 设置素材标签
     *
     * @param materialDtoList 素材列表
     * @return 设置标签素材列表
     */
    List<MaterialDto> setMaterialTagList(List<MaterialDto> materialDtoList);

    /**
     * @Description  包含父子关系的素材标签设置
     * @Date 18:13 2020-05-09
     * @Param [materialDtoList]
     * @return java.util.List<cn.com.duiba.tuia.ssp.center.api.dto.MaterialDto>
     **/
    List<MaterialDto> setMaterialTagListWithParent(List<MaterialDto> materialDtoList);

    /**
     * 设置素材可用状态
     * @param materialToActDtoList 素材
     * @return 设置可用状态后素材
     */
    List<MaterialToActDto> setMaterialAvailableStatus(List<MaterialToActDto> materialToActDtoList);

    /**
     * @Author zhangliwei
     * @Description  订正picture_val为空的所有素材数据,只初始化一次,不要调用!!
     * @Date 16:53 2019-12-06
     * @Param []
     * @return boolean
     **/
    boolean initEmptyPictureVal();

    /**
     * 保存在投素材
     */
    boolean saveMaterialRelease(MaterialReleaseDTO materialReleaseDTO);

    /**
     * 删除在投素材
     */
    boolean removeMaterialRelease(MaterialReleaseDTO materialReleaseDTO);

    List<Long> getMaterialIdsByTagTitles(List<String> titles);

    /**
     * @Author zhangliwei
     * @Description  根据素材ID列表查询素材效果集合
     * @Date 14:58 2020-02-06
     * @Param [ids]
     * @return java.util.List<cn.com.duiba.tuia.ssp.center.api.dto.MaterialEffectDto>
     **/
    List<MaterialEffectDto> getMaterialEffects(List<Long> ids);

    /**
     * 取出积木弹层所有标签
     * @param titles
     * @return
     */
    List<TagLibraryDto> listByTitles(List<String> titles);

    /**
     * @Description  设置父级
     * @Date 15:08 2020-04-28
     * @Param [materialRsp]
     * @return java.lang.Long
     **/
    public Boolean setFather(ReqMaterialDto materialRsp);

    /**
     * @Description  下载日志 +1
     * @Date 15:12 2020-04-28
     * @Param [id]
     * @return boolean
     **/
    public boolean addDownloadCount(Long id);

    /**
     * @Description  根据父ID集合,查询统计数据
     * @Date 21:13 2020-05-06
     * @Param [param]
     * @return cn.com.duiba.wolf.dubbo.DubboResult<java.util.List<cn.com.duiba.tuia.ssp.center.api.dto.MaterialDto>>
     **/
    List<MaterialDto> listCountByPids(ReqMaterialDto param);


    List<MaterialTagDTO> getMaterialTagDTO(List<Long> materialIdList);

    /**
     * 根据素材id查询素材
     * @param ids
     * @return
     */
    List<MaterialDto> selectByIds(List<Long> ids);
    /**
     * 根据素材ID, 获取有效的素材
     * @param slotId
     * @param idList
     * @return
     */
    List<MaterialToActDto> findValidMaterialByIdList(Long slotId, List<Long> idList);

    /**
     * 根据素材ID集合,获取素材静态特征(一系列标签,用于算法)
     * @param idList
     * @return
     */
    List<MaterialFeatureDto> getMaterialFeatures(List<Long> idList);

    /**
     * 获取素材格式 类型
     * @param materialIds
     * @return
     */
    List<Integer> listFormatTypeByIds(List<Long> materialIds);

    /**
     * 根据广告位查询关联的素材数量，不去重、不管状态
     * @param slotId
     * @return
     */
    Long selectSckNumBySlotId(Long slotId);

    List<MaterialTagSimpleDTO> listByMaterialIdListOld(List<Long> materialIdList);

    Long selectMaterialIdOld(Long materialId);

}
