package cn.com.duiba.tuia.ssp.center.api.dto;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 问题广告位活动
 *
 * @author zhangzhenghe
 * @since 2020-02-19 4:52 PM
 */
@Data
public class SlotActivityProblemsDTO implements Serializable {

    private static final long serialVersionUID = 5169451179917930135L;

    /**
     * 日期
     */
    private Date curDate;

    /**
     * 广告位ID
     */
    private Long slotId;

    /**
     * 活动ID
     */
    private Long activityId;

    /**
     * 问题类型(1:活动效益变差 2:优质活动占比需提升 3:长期未更换活动)
     */
    private Integer problemType;

    /**
     * 活动投放周期（天）
     */
    private Long actServingDay;

    /**
     * 变现效率低于广告位平均水平n%（10000倍率）
     */
    private Long actMonetizeEfficiencyRate;

    /**
     * 变现收益高于广告位平均水平n%（10000倍率）
     */
    private Long actMonetizeIncomeRate;

    /**
     * 变现效率降低n%（10000倍率）
     */
    private Long actMonetizeEfficiencyDownRate;
}
