package cn.com.duiba.tuia.ssp.center.api.dto;

import cn.com.duiba.tuia.ssp.center.api.constant.enums.FileCollectShieldStatusEnum;
import cn.com.duiba.tuia.ssp.center.api.tool.DateUtil;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author K. L. Mao
 * @create 2019-12-10
 */
@Data
public class FileCollectShieldConfigDTO implements Serializable {

    /** The id. */
    private Long  id;

    /** 创建时间. */
    @JsonFormat(pattern = DateUtil.DEFAULT_FORMATTER, timezone = "GMT+8")
    private Date gmtCreate;

    /** 最新更新时间. */
    @JsonFormat(pattern = DateUtil.DEFAULT_FORMATTER, timezone = "GMT+8")
    private Date gmtModified;

    /**
     * 手机品牌
     */
    private String phoneBrand;

    /**
     * 手机型号
     */
    private String phoneType;

    /**
     * 屏蔽状态：1：屏蔽中；9：其他
     *
     * {@link FileCollectShieldStatusEnum}
     */
    private Integer status;

    /**
     * 是否删除 0：未删除；1：已删除
     */
    private Boolean isDelete;

}
