package cn.com.duiba.tuia.ssp.center.api.constant;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 素材格式类型
 */
@Getter
@AllArgsConstructor
public enum MaterialFormatTypeEnum {

    /**
     * 普通类型
     */
    NORMAL(0),
    /**
     * SVGA类型
     */
    SVGA(1),
    ;

    private Integer type;

    public static Set<Integer> getAllTypes() {
        return Arrays.stream(MaterialFormatTypeEnum.values()).map(MaterialFormatTypeEnum::getType).collect(Collectors.toSet());
    }
}
