package cn.com.duiba.tuia.ssp.center.api.remote;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.SlotPreWarnInfoRsp;
import cn.com.duiba.tuia.ssp.center.api.dto.SlotPreWarnPageReq;
import cn.com.duiba.tuia.ssp.center.api.dto.SlotProposalPriceDTO;
import cn.com.duiba.tuia.ssp.center.api.dto.SlotProposalPriceReq;

import java.util.List;

/**
 * 风控回流建议分成价格表
 *
 * @author YWG.MID.P
 * @date 2020-09-28 07:29:05
 */
@AdvancedFeignClient
public interface RemoteSlotProposalPriceService {

    SlotProposalPriceDTO getById(Long id);

    void save(SlotProposalPriceDTO dto);

    void updateById(SlotProposalPriceDTO dto);

    void removeByIds(List<Long> ids);

    /**
     * @Description  根据媒体ID集合查询预警广告位顶部统计信息
     * @Param [appIds]
     * @return cn.com.duiba.tuia.ssp.center.api.dto.SlotPreWarnInfoRsp
     **/
    SlotPreWarnInfoRsp getInfoByAppIds(List<Long> appIds);

    /**
     * @Description  预警广告位数量统计
     * @Param [req]
     * @return java.lang.Integer
     **/
    Integer countPreWarnList(SlotPreWarnPageReq req);

    /**
     * @Description  预警广告位数据分页查询
     * @Param [req]
     * @return java.util.List<cn.com.duiba.tuia.ssp.center.api.dto.SlotProposalPriceReq>
     **/
    List<SlotProposalPriceDTO> getPageList(SlotPreWarnPageReq req);


}

