package cn.com.duiba.tuia.ssp.center.api.dto;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 结算预警
 */
@Data
public class SettledPrewarningDTO implements Serializable {

    private static final long serialVersionUID = -7624691338944987876L;

    /**
     * 	账号ID
     */
    private Long mediaId;

    /**
     * 预警类型（1：发票预警 2：结算单预警 3：预付款余额预警）
     */
    private Integer prewarningType;

    /**
     * 预付款余额预警等级（1:一级预警 2:二级预警 3:三级预警）
     */
    private Integer prewarningLevel;

    /**
     * 预警内容
     */
    private String prewarningContent;

    /**
     * 日期
     */
    private Date curDate;

    /**
     * 发票预警
     */
    @Data
    public static class InvoicePrewarningContent {

        private String invoicePrewarning;

        private Long invoiceHcdjUnbilledAmount;

        private Long invoiceHegsUnbilledAmount;

        private Long invoiceHzUnbilledAmount;
    }

    /**
     * 结算单预警
     */
    @Data
    public static class SettledPrewarningContent {

        private String settledPrewarning;

        private List<SettledPrewarningData> settledPrewarningList;

        @Data
        public static class SettledPrewarningData {

            private String settledDate;

            private Long debtAmount;
        }
    }
}
