package cn.com.duiba.tuia.ssp.center.api.dto.media;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * @author yuantong
 * @version 1.0
 * @since 2020-02-25 15:00
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class MediaAdvertDto  implements Serializable {

    /*
     * 序列化 SerialVersionUId
     */
    private static final long serialVersionUID = 1L;

    /*
     * 广告 Id
     */
    private Long advertId;

    /*
     * 广告 Id
     * 注 : 媒体方广告 , 提审后媒体方会生成一个他们的广告 Id 返回
     */
    private Long mediaAdvertId;

    /*
     * 广告名称
     */
    private String advertName;

    /*
     * 广告状态
     * -- 0 : 无效 · 兑吧广告
     * -- 1 : 有效
     * -- 2 : 无效 · 暂停
     * -- 3 : 无效 · 审核中
     * -- 4 : 无效 · 审核拒绝
     * -- 5 : 无效 · 账号余额不足
     * -- 6 : 无效 · 账号预算不足
     * -- 7 : 无效 · 广告预算不足
     * -- 8 : 无效 · 库存不足
     * -- 9 : 无效 · 非投放日期
     * -- 10 : 无效 · 优惠码失效
     * -- 11 : 无效 · 落地页审核被拒绝
     */
    private Integer advertStatus;

    /*
     * 广告行业
     */
    private String advertIndustry;

    /*
     * 广告预算
     */
    private Long advertBudget;

    /*
     * 落地页 Url
     */
    private String landingPage;

    /*
     * 素材 Url
     */
    private String materialUrl;

    /*
     * 投放开关
     * -- { 0 : 关闭 , 1 : 开启 }
     */
    private Integer materialSwitch;

    /*
     * 审核状态
     * -- { 0 : 初始化 , 1 : 待审核 , 2 : 审核通过 , 3 : 审核拒接 , 4 : 系统下线 }
     */
    private Integer reviewStatus;

    /*
     * 审核备注
     */
    private String remark;

    /*
     * AE 姓名
     */
    private String aeName;
}
