package cn.com.duiba.tuia.ssp.center.api.remote;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.MediaLinkCheckDTO;
import cn.com.duiba.tuia.ssp.center.api.dto.MediaLinkUploadFailDTO;
import cn.com.duiba.tuia.ssp.center.api.dto.PageResultDto;

import java.util.List;

/**
 * @author: tangzhen@duiba.com.cn
 * @date:2020/6/3
 * @description: 落地页链接审核-媒体管理用
 **/
@AdvancedFeignClient
public interface RemoteMediaLinkCheckMediaService {

    /**
     * 查询媒体落地页链接审核列表
     * @param mediaLinkCheck
     * @return
     */
    PageResultDto<MediaLinkCheckDTO> getList(MediaLinkCheckDTO mediaLinkCheck);

    /**
     * 查询媒体落地页链接审核列表- host维度
     * @param mediaLinkCheck
     */
    PageResultDto<MediaLinkCheckDTO> getHostList(MediaLinkCheckDTO mediaLinkCheck);

    /**
     * 批量审批--完整链接
     */
    Integer batchCheck(MediaLinkCheckDTO mediaLinkCheck);

    /**
     * 批量审核域名
     * @return
     */
    Integer batchCheckHost(MediaLinkCheckDTO mediaLinkCheck);


    /**
     * 上传审核
     * @param linkUploadFailDTOList
     * @return
     */
    List<MediaLinkUploadFailDTO> uploadCheck(List<MediaLinkUploadFailDTO> linkUploadFailDTOList, String gmtUser);


}
