package cn.com.duiba.tuia.ssp.center.api.dto.sdk;

import cn.com.duiba.tuia.ssp.center.api.dto.BaseDto;
import lombok.Getter;
import lombok.Setter;

import java.util.List;

@Getter
@Setter
public class TuiaSdkVerifyRecordHistoryDTO extends BaseDto {

    public static final Integer PATCH_RELEASE_STATUS_GRAY = 1; // 灰度中
    public static final Integer PATCH_RELEASE_STATUS_FULL = 2; // 全量中
    public static final Integer PATCH_RELEASE_STATUS_STOP = 3; // 停止
    public static final Integer PATCH_RELEASE_STATUS_ROLLBACK = 4; // 回滚中

    private Long id;
    private Long verifyRecordId; // 发布记录ID
    private Integer sdkVersionCode; // SDK版本code
    private Integer patchCode; // 补丁版本Code
    private String patchName; // 补丁版版本号
    private Integer patchReleaseType; // 补丁发布类型：1=灰度中、2=全量
    private Integer patchReleaseStatus; // 状态：1=灰度中、2=发布中、3=停止、4=回滚中
    private String patchReleaseDesc; // 备注
    private Integer patchCheckStatus; // 审核状态：0=未审核、1=审核中、2=已通过、3=拒绝
    private Long limitCountCur; // 灰度发布当前人数
    private Long limitCountMax; // 灰度发布最大人数
}