/**
 * Project Name:media-manager-biz<br>
 * File Name:ReqAppHourStatistics.java<br>
 * Package Name:cn.com.duiba.tuia.media.manager.model.req<br>
 * Date:2016年12月22日上午11:25:45<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */
package cn.com.duiba.tuia.ssp.center.api.dto;

import java.io.Serializable;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;

import org.apache.commons.lang3.builder.ToStringBuilder;

/**
 * ClassName: ReqSlotHourStatistics <br/>
 * Function: 每小时数据请求对象. <br/>
 * date: 2016年12月22日 上午11:25:45 <br/>
 *
 * @author zfz
 * @version
 * @since JDK 1.6
 */
@ApiModel
public class ReqSlotStatHour extends ReqStatHourlySort implements Serializable {

    /** The Constant serialVersionUID. @since JDK 1.6 */
    private static final long serialVersionUID = 3111692842635686910L;

    /** 广告位ID. */
    @ApiModelProperty(value = "广告位ID", required = false)
    private Long              slotId;

    /** 查询日期. */
    @ApiModelProperty(value = "查询日期", required = true)
    @NotNull(message = "查询日期不能为空")
    private String            curDate;

    /** The slot name. */
    @ApiModelProperty(value = "广告位名称(用作导出)", required = false)
    private String            slotName;

    /**
     * slotId.
     *
     * @return the slotId
     * @since JDK 1.6
     */
    public Long getSlotId() {
        return slotId;
    }

    /**
     * slotId.
     *
     * @param slotId the slotId to set
     * @since JDK 1.6
     */
    public void setSlotId(Long slotId) {
        this.slotId = slotId;
    }

    /**
     * curDate.
     *
     * @return the curDate
     * @since JDK 1.6
     */
    public String getCurDate() {
        return curDate;
    }

    /**
     * curDate.
     *
     * @param curDate the curDate to set
     * @since JDK 1.6
     */
    public void setCurDate(String curDate) {
        this.curDate = curDate;
    }

    /**
     * Gets the slot name.
     *
     * @return the slot name
     */
    public String getSlotName() {
        return slotName;
    }

    /**
     * Sets the slot name.
     *
     * @param slotName the slot name
     */
    public void setSlotName(String slotName) {
        this.slotName = slotName;
    }

    /**
     * To string.
     *
     * @return the string
     */
    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
