package cn.com.duiba.tuia.ssp.center.api.remote.sdk;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.PageResultDto;
import cn.com.duiba.tuia.ssp.center.api.dto.sdk.TuiaSdkPatchDTO;
import cn.com.duiba.tuia.ssp.center.api.dto.sdk.TuiaSdkRecordDTO;
import cn.com.duiba.tuia.ssp.center.api.dto.sdk.TuiaSdkVerifyRecordDTO;

import java.util.List;


@AdvancedFeignClient
public interface RemoteTuiaVerifyRecordService {

    TuiaSdkVerifyRecordDTO getById(Long id);

    List<TuiaSdkVerifyRecordDTO> findAll();

    PageResultDto<TuiaSdkVerifyRecordDTO> findByPage(Integer pageSize, Integer currentPage);

    PageResultDto<TuiaSdkVerifyRecordDTO> history(Long releaseId, Integer pageSize, Integer currentPage);

    TuiaSdkRecordDTO getLastRecordDto(Long pluginSetId);

    TuiaSdkVerifyRecordDTO getEditId(Long sdkVersionCode, Long patchCode, Integer releaseType, Integer patchReleaseType);

    int getByPluginCode(Long pluginCode);

    /**
     * 根据sdk版本号获取补丁列表
     * open-web 使用
     * @param sdkVersionName
     * @return
     */
    List<TuiaSdkPatchDTO> findBySdkVersionName(String sdkVersionName);

    /**
     * 灰度补丁人数加1
     * open-web 使用
     * @param id
     * @return
     */
    Boolean incPatchLimitCur(Long id);

    List<TuiaSdkVerifyRecordDTO> findBySdkVersionCode(Long sdkVersionCode);
}
