package cn.com.duiba.tuia.ssp.center.api.dto;

import cn.com.duiba.tuia.ssp.center.api.tool.DateUtil;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 流量调整历史记录
 */
@Data
public class SlotFlowHistoryDTO implements Serializable {

    private static final long serialVersionUID = 7428946867802334550L;

    /**
     * 媒体ID
     */
    private Long appId;

    /**
     * 广告位ID
     */
    private Long slotId;

    /**
     * 广告位名称
     */
    private String slotName;

    /**
     * 计费方式（0:分成 1:CPC 2:CPM 3:UV单价 4:CPT）
     */
    private Integer chargeType;

    /**
     * 修改前比例
     */
    private Integer beforeRatio;

    /**
     * 修改后比例
     */
    private Integer afterRatio;

    /**
     * 记录类型（0:今日配置 1:长期配置）
     */
    private Integer configType;

    /**
     * 管理员ID
     */
    private Long managerId;

    /**
     * 日期
     */
    @JsonFormat(pattern = DateUtil.DEFAULT_FORMATTER, timezone = "GMT+8")
    private Date gmtCreate;
}

