/**
 * Copyright (c) 2018, Ysoul. All rights reserved.
 */
package cn.com.duiba.tuia.ssp.center.api.remote;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.DomainCheckManagerDto;
import cn.com.duiba.tuia.ssp.center.api.dto.PageResultDto;
import cn.com.duiba.tuia.ssp.center.api.params.DomainCheckManagerQuery;

import java.util.List;

/**
 * 类描述: 域名管理查询
 *
 * @author <a href="651850874@qq.com">Ysoul</a>
 * @version 1.0 2018-01-24
 * @since 1.0
 */
@AdvancedFeignClient
public interface RemoteDomainCheckManagerService {

    /**
     * 查询
     *
     * @param id
     * @return
     */
    DomainCheckManagerDto selectById(Long id);

    /**
     * 查询
     *
     * @param domainName
     * @return
     */
    DomainCheckManagerDto selectByDomainName(String domainName);

    /**
     * 批量查询
     *
     * @param domainNameList
     * @return
     */
    List<DomainCheckManagerDto> selectByDomainNameList(List<String> domainNameList);

    /**
     * 查询有效的游戏域名
     * @return
     */
    List<DomainCheckManagerDto> selectValidGameDomain();

    /**
     * 分页查询
     *
     * @param query
     * @return
     */
    PageResultDto<DomainCheckManagerDto> selectByParams(DomainCheckManagerQuery query);

    /**
     * 获取所有
     * @return
     */
    List<DomainCheckManagerDto> selectAll();

    /**
     * 插入
     *
     * @param domainCheckManagerDto
     * @return
     */
    int insert(DomainCheckManagerDto domainCheckManagerDto);

    /**
     * 批量插入
     *
     * @param list
     * @return
     */
    int insertBatch(List<DomainCheckManagerDto> list);

    /**
     * 更新
     *
     * @param domainCheckManagerDto
     * @return
     */
    int update(DomainCheckManagerDto domainCheckManagerDto);

    /**
     * 域名策略预警
     *
     * @param dto
     * @param firstBlood 第一次被微信屏蔽
     */
    void warning(DomainCheckManagerDto dto, int firstBlood);

    void reSetDomainTagRelation();

}
