/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.ssp.center.api.tool;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import java.util.Objects;
import okhttp3.Call;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OCRUtil {
    private static final Logger log = LoggerFactory.getLogger(OCRUtil.class);
    private static final String INVOICE_URL = "https://ocrapi-invoice.taobao.com/ocrservice/invoice";
    private static final String INVOICE_APP_CODE = "e6c12fd07875453cbe650280d86e1e4f";

    public static InvoiceResult getInvoiceResult(String img, String url) {
        if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{img, url})) {
            throw new RuntimeException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{img, url})) {
            throw new RuntimeException("\u53ea\u80fd\u5176\u4e2d\u4e00\u4e2a\u53c2\u6570\u6709\u503c");
        }
        if (StringUtils.isBlank((CharSequence)img)) {
            img = "";
        }
        if (StringUtils.isBlank((CharSequence)url)) {
            url = "";
        }
        MediaType jsonType = MediaType.parse((String)"application/json; charset=utf-8");
        RequestBody body = RequestBody.create((MediaType)jsonType, (String)("{\"img\":\"" + img + "\",\"url\":\"" + url + "\"}"));
        Request request = new Request.Builder().url(INVOICE_URL).header("Authorization", "APPCODE e6c12fd07875453cbe650280d86e1e4f").header("Content-Type", "application/json; charset=UTF-8").post(body).build();
        OkHttpClient client = new OkHttpClient();
        Call call = client.newCall(request);
        try {
            Response response = call.execute();
            String result = Objects.requireNonNull(response.body()).toString();
            log.info("OCR\u8bc6\u522b\u7ed3\u679c result={}", (Object)result);
            JSONObject jsonObject = JSONObject.parseObject((String)result);
            if (StringUtils.isNotBlank((CharSequence)jsonObject.getString("error_code"))) {
                throw new RuntimeException(jsonObject.getString("error_msg"));
            }
            return (InvoiceResult)JSONObject.parseObject((String)result, InvoiceResult.class);
        }
        catch (Exception e) {
            log.error("OCR\u8bc6\u522b\u5f02\u5e38", (Throwable)e);
            throw new RuntimeException(e.getMessage());
        }
    }

    public static class InvoiceResult {
        @JSONField(name="\u53d1\u7968\u4ee3\u7801")
        private String invoiceCode;
        @JSONField(name="\u53d1\u7968\u53f7\u7801")
        private String invoiceNo;
        @JSONField(name="\u5f00\u7968\u65e5\u671f")
        private String invoiceDate;
        @JSONField(name="\u6821\u9a8c\u7801")
        private String invoiceVerifyCode;
        @JSONField(name="\u53d1\u7968\u91d1\u989d")
        private String invoiceAmount;
        @JSONField(name="\u53d1\u7968\u7a0e\u989d")
        private String invoiceTaxAmount;
        @JSONField(name="\u4e0d\u542b\u7a0e\u91d1\u989d")
        private String invoiceNotIncludedTaxAmount;
        @JSONField(name="\u53d7\u7968\u65b9\u540d\u79f0")
        private String customerName;
        @JSONField(name="\u53d7\u7968\u65b9\u7a0e\u53f7")
        private String customerNo;
        @JSONField(name="\u53d7\u7968\u65b9\u5730\u5740\u3001\u7535\u8bdd")
        private String customerAddressTel;
        @JSONField(name="\u53d7\u7968\u65b9\u5f00\u6237\u884c\u3001\u8d26\u53f7")
        private String customerBankAccount;
        @JSONField(name="\u9500\u552e\u65b9\u540d\u79f0")
        private String sellerName;
        @JSONField(name="\u9500\u552e\u65b9\u7a0e\u53f7")
        private String sellerNo;
        @JSONField(name="\u9500\u552e\u65b9\u5730\u5740\u3001\u7535\u8bdd")
        private String sellerAddressTel;
        @JSONField(name="\u9500\u552e\u65b9\u5f00\u6237\u884c\u3001\u8d26\u53f7")
        private String sellerBankAccount;

        public void setInvoiceCode(String invoiceCode) {
            this.invoiceCode = invoiceCode;
        }

        public void setInvoiceNo(String invoiceNo) {
            this.invoiceNo = invoiceNo;
        }

        public void setInvoiceDate(String invoiceDate) {
            this.invoiceDate = invoiceDate;
        }

        public void setInvoiceVerifyCode(String invoiceVerifyCode) {
            this.invoiceVerifyCode = invoiceVerifyCode;
        }

        public void setInvoiceAmount(String invoiceAmount) {
            this.invoiceAmount = invoiceAmount;
        }

        public void setInvoiceTaxAmount(String invoiceTaxAmount) {
            this.invoiceTaxAmount = invoiceTaxAmount;
        }

        public void setInvoiceNotIncludedTaxAmount(String invoiceNotIncludedTaxAmount) {
            this.invoiceNotIncludedTaxAmount = invoiceNotIncludedTaxAmount;
        }

        public void setCustomerName(String customerName) {
            this.customerName = customerName;
        }

        public void setCustomerNo(String customerNo) {
            this.customerNo = customerNo;
        }

        public void setCustomerAddressTel(String customerAddressTel) {
            this.customerAddressTel = customerAddressTel;
        }

        public void setCustomerBankAccount(String customerBankAccount) {
            this.customerBankAccount = customerBankAccount;
        }

        public void setSellerName(String sellerName) {
            this.sellerName = sellerName;
        }

        public void setSellerNo(String sellerNo) {
            this.sellerNo = sellerNo;
        }

        public void setSellerAddressTel(String sellerAddressTel) {
            this.sellerAddressTel = sellerAddressTel;
        }

        public void setSellerBankAccount(String sellerBankAccount) {
            this.sellerBankAccount = sellerBankAccount;
        }

        public String getInvoiceCode() {
            return this.invoiceCode;
        }

        public String getInvoiceNo() {
            return this.invoiceNo;
        }

        public String getInvoiceDate() {
            return this.invoiceDate;
        }

        public String getInvoiceVerifyCode() {
            return this.invoiceVerifyCode;
        }

        public String getInvoiceAmount() {
            return this.invoiceAmount;
        }

        public String getInvoiceTaxAmount() {
            return this.invoiceTaxAmount;
        }

        public String getInvoiceNotIncludedTaxAmount() {
            return this.invoiceNotIncludedTaxAmount;
        }

        public String getCustomerName() {
            return this.customerName;
        }

        public String getCustomerNo() {
            return this.customerNo;
        }

        public String getCustomerAddressTel() {
            return this.customerAddressTel;
        }

        public String getCustomerBankAccount() {
            return this.customerBankAccount;
        }

        public String getSellerName() {
            return this.sellerName;
        }

        public String getSellerNo() {
            return this.sellerNo;
        }

        public String getSellerAddressTel() {
            return this.sellerAddressTel;
        }

        public String getSellerBankAccount() {
            return this.sellerBankAccount;
        }

        public String toString() {
            return "OCRUtil.InvoiceResult(invoiceCode=" + this.getInvoiceCode() + ", invoiceNo=" + this.getInvoiceNo() + ", invoiceDate=" + this.getInvoiceDate() + ", invoiceVerifyCode=" + this.getInvoiceVerifyCode() + ", invoiceAmount=" + this.getInvoiceAmount() + ", invoiceTaxAmount=" + this.getInvoiceTaxAmount() + ", invoiceNotIncludedTaxAmount=" + this.getInvoiceNotIncludedTaxAmount() + ", customerName=" + this.getCustomerName() + ", customerNo=" + this.getCustomerNo() + ", customerAddressTel=" + this.getCustomerAddressTel() + ", customerBankAccount=" + this.getCustomerBankAccount() + ", sellerName=" + this.getSellerName() + ", sellerNo=" + this.getSellerNo() + ", sellerAddressTel=" + this.getSellerAddressTel() + ", sellerBankAccount=" + this.getSellerBankAccount() + ")";
        }
    }
}

