/**
 * Project Name:media-biz
 * File Name:BaseCashBillDto.java
 * Package Name:cn.com.duiba.tuia.media.domain
 * Date:2017年5月9日下午4:10:38
 * Copyright (c) 2017, duiba.com.cn All Rights Reserved.
 *
*/

package cn.com.duiba.tuia.ssp.center.api.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.validator.constraints.NotBlank;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * ClassName:BaseCashBillDto <br/>
 * Function: 提现信息. <br/>
 * Date:     2017年5月9日 下午4:10:38 <br/>
 * @author   guyan
 * @version  
 * @since    JDK 1.6
 * @see 	 
 */
@Api("发票信息")
@Data
public class BaseCashBillDto implements Serializable  {
    
    private static final long serialVersionUID = -3237195163611290437L;

    @ApiModelProperty(value = "主键", required = true)
    private Long id;

    @JsonIgnore
    @ApiModelProperty(value = "账号ID")
    private Long mediaId;

    @JsonIgnore
    @ApiModelProperty(value = "公司主体")
    private Integer companyType;

    @ApiModelProperty(value = "发票照片", required = true)
    @NotBlank(message="发票照片不能为空")
    private String pictureUrl;

    @ApiModelProperty(value = "发票金额", required = true)
    @NotNull(message="发票金额不能为空")
    private Long invoiceAmount;

    @ApiModelProperty(value = "发票税额", required = true)
    @NotNull(message="发票税额不能为空")
    private Long invoiceTaxAmount;

    @ApiModelProperty(value = "不含税金额", required = true)
    @NotNull(message="不含税金额不能为空")
    private Long invoiceNotIncludedTaxAmount;

    @ApiModelProperty(value = "发票号", required = true)
    @NotBlank(message="发票号不能为空")
    private String invoiceNo;

    @ApiModelProperty(value = "购买方名称", required = true)
    @NotBlank(message="购买方名称不能为空")
    private String customerName;

    @ApiModelProperty(value = "购买方纳税人识别号", required = true)
    @NotBlank(message="购买方纳税人识别号不能为空")
    private String customerNo;

    @ApiModelProperty(value = "销售方名称", required = true)
    @NotBlank(message="销售方名称不能为空")
    private String sellerName;

    @ApiModelProperty(value = "销售方纳税人识别号", required = true)
    @NotBlank(message="销售方纳税人识别号不能为空")
    private String sellerNo;

    @ApiModelProperty(value = "开票日期（格式：yyyy-MM-dd）")
    private String invoiceDate;

    @ApiModelProperty(value = "税率")
    private Integer taxRatio;

    /**
     * 提现单号
     */
    @JsonIgnore
    private Long cashOrderId;

    /**
     * 发票类型（1：预付款单 2：提现单 3：预付款结算单）
     */
    @JsonIgnore
    private Integer invoiceType;
}

