package cn.com.duiba.tuia.ssp.center.api.remote.monthreport;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.monthreport.*;

import java.util.List;

/**
 * @author fangzhipeng
 * @date 2018/9/16
 */
@AdvancedFeignClient
public interface RemoteMonthReportDataService {
    /**
     * 媒体总收益
     *
     * @return
     */
    Long computeMediaTotalConsumeTotal(ReqMonthReportDataDto req);

    /**
     * 收益最高日
     * @return
     */
    ConsumeDate computeMaxConsumeTotalDate(ReqMonthReportDataDto req);

    /**
     * 获取收益最高媒体
     * @return
     */
    ConsumeApp computeMaxConsumeTotalApp(ReqMonthReportDataDto req);

    /**
     * 获取收益最高的广告位
     * @return
     */
    ConsumeSlot computeMaxConsumeTotalSlot(ReqMonthReportDataDto req);

    /**
     * 收益top5 + 其他 广告位
     * @param req
     * @return
     */
    List<ConsumeSlot> computeTopConsumeSlot(ReqMonthReportDataDto req);


    /**
     * 收益top5 + 其他 媒体
     * @param req
     * @return
     */
    List<ConsumeApp> computeTopConsumeApp(ReqMonthReportDataDto req);


    /**
     *
     * @param req
     * @return
     */
    List<ConsumeDate> computeTopConsumeDate(ReqMonthReportDataDto req);


    /**
     * 收益访问数据图
     *
     * @param req
     * @return
     */
    List<ConsumeVisitData> computeConsumeVisitData(DetailDataReq req);


    /**
     * 入口数据
     *
     * @param req
     * @return
     */
    List<EntranceData> computeEntranceData(DetailDataReq req);
}
