package cn.com.duiba.tuia.ssp.center.api.remote;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.ssp.center.api.dto.MediaManagerDto;
import cn.com.duiba.tuia.ssp.center.api.dto.ReqMediaManagerCreateDto;
import cn.com.duiba.wolf.dubbo.DubboResult;

import java.util.List;

/**
 * 媒体--管理员关联关系接口
 *
 * @author songjiaxing
 */
@AdvancedFeignClient
public interface RemoteMediaManagerBackendService {

    /**
     * 关联媒体和管理员
     *
     * @return
     */
    DubboResult<Integer> createMediaManager(ReqMediaManagerCreateDto createDto);

    /**
     * 批量关联媒体和管理员
     *
     * @return
     */
    DubboResult<Integer> createMediaManagerList(List<ReqMediaManagerCreateDto> createDtoList);

    /**
     * 批量关联媒体和管理员
     *
     * @return
     */
    Integer createMediaManagers(List<ReqMediaManagerCreateDto> createDtoList, Integer managerType);

    /**
     * 删除媒体和管理员关联关系
     *
     * @return
     */
    DubboResult<Integer> deleteByMediaId(Long mediaId);

    /**
     * 根据管理员id查询可操作的媒体
     *
     * @param managerId
     * @return
     */
    DubboResult<List<MediaManagerDto>> listByManagerId(Long managerId);

    /**
     * 根据媒体id查询所属管理员
     *
     * @param mediaId
     * @return
     */
    DubboResult<List<MediaManagerDto>> listByMediaId(Long mediaId);

    DubboResult<List<MediaManagerDto>> listByMediaList(List<Long> medias);

    /**
     * 根据管理员ids查询可操作的媒体
     *
     * @return
     */
    List<MediaManagerDto> listByManagerIds(List<Long> managerIds);

    int insert(MediaManagerDto record);


}
